/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine.phases;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Messages;
import org.osgi.framework.BundleContext;

public class Sizing
extends InstallableUnitPhase {
    private static final String PHASE_ID = "collect";
    private long sizeOnDisk;
    private long dlSize;
    static /* synthetic */ Class class$0;

    public Sizing(int weight, String phaseName) {
        super(PHASE_ID, weight);
    }

    protected boolean isApplicable(InstallableUnitOperand op) {
        return op.second() != null;
    }

    public long getDiskSize() {
        return this.sizeOnDisk;
    }

    public long getDlSize() {
        return this.dlSize;
    }

    protected ProvisioningAction[] getActions(InstallableUnitOperand currentOperand) {
        ProvisioningAction action = Sizing.getTouchpoint(currentOperand).getAction(PHASE_ID);
        return new ProvisioningAction[]{action};
    }

    protected String getProblemMessage() {
        return Messages.Phase_Sizing_Error;
    }

    protected IStatus completeInstallableUnitPhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        List artifactRequests = (List)parameters.get("artifactRequests");
        HashSet<IArtifactRequest> artifactsToObtain = new HashSet<IArtifactRequest>(artifactRequests.size());
        Iterator it = artifactRequests.iterator();
        while (it.hasNext()) {
            IArtifactRequest[] requests = (IArtifactRequest[])it.next();
            if (requests == null) continue;
            int i = 0;
            while (i < requests.length) {
                artifactsToObtain.add(requests[i]);
                ++i;
            }
        }
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IArtifactRepositoryManager repoMgr = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        URL[] repositories = null;
        repositories = this.provContext == null || this.provContext.getArtifactRepositories() == null ? repoMgr.getKnownRepositories(0) : this.provContext.getArtifactRepositories();
        Iterator iterator = artifactsToObtain.iterator();
        block6: while (iterator.hasNext()) {
            IArtifactRequest artifactRequest = (IArtifactRequest)iterator.next();
            int i = 0;
            while (i < repositories.length) {
                block12: {
                    IArtifactRepository repo;
                    try {
                        repo = repoMgr.loadRepository(repositories[i], null);
                    }
                    catch (ProvisionException provisionException) {
                        break block12;
                    }
                    IArtifactDescriptor[] descriptors = repo.getArtifactDescriptors(artifactRequest.getArtifactKey());
                    if (descriptors.length > 0) {
                        if (descriptors[0].getProperty("artifact.size") != null) {
                            this.sizeOnDisk += Long.parseLong(descriptors[0].getProperty("artifact.size"));
                        }
                        if (descriptors[0].getProperty("download.size") == null) continue block6;
                        this.dlSize += Long.parseLong(descriptors[0].getProperty("download.size"));
                        continue block6;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected IStatus initializeInstallableUnitPhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        parameters.put("artifactRequests", new ArrayList());
        return null;
    }
}

