/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;

public class SurrogateProfileHandler
implements ISurrogateProfileHandler {
    private static final String ORG_ECLIPSE_EQUINOX_P2_NATIVE = "org.eclipse.equinox.p2.native";
    private static final String ORG_ECLIPSE_EQUINOX_P2_TYPE_ROOT = "org.eclipse.equinox.p2.type.root";
    private static final String P2_ENGINE_DIR = "p2/org.eclipse.equinox.p2.engine/";
    private static final String OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String ECLIPSE_INI_IGNORED = "eclipse.ini.ignored";
    public static final String PROP_SURROGATE = "org.eclipse.equinox.p2.surrogate";
    private SimpleProfileRegistry profileRegistry;
    static /* synthetic */ Class class$0;

    private synchronized SimpleProfileRegistry getProfileRegistry() {
        if (this.profileRegistry == null) {
            String installArea = EngineActivator.getContext().getProperty(OSGI_INSTALL_AREA);
            try {
                URL registryURL = new URL(String.valueOf(installArea) + P2_ENGINE_DIR + "profileRegistry");
                File sharedRegistryDirectory = new File(registryURL.getPath());
                this.profileRegistry = new SimpleProfileRegistry(sharedRegistryDirectory, null);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.profileRegistry;
    }

    public Profile createProfile(String id) {
        final IProfile sharedProfile = this.getProfileRegistry().getProfile(id);
        if (sharedProfile == null) {
            return null;
        }
        Query rootIUQuery = new Query(){

            public boolean isMatch(Object candidate) {
                if (candidate instanceof IInstallableUnit) {
                    IInstallableUnit iu = (IInstallableUnit)candidate;
                    if (Boolean.valueOf(sharedProfile.getInstallableUnitProperty(iu, SurrogateProfileHandler.ORG_ECLIPSE_EQUINOX_P2_TYPE_ROOT)).booleanValue()) {
                        return true;
                    }
                    if (iu.getTouchpointType().getId().equals(SurrogateProfileHandler.ORG_ECLIPSE_EQUINOX_P2_NATIVE)) {
                        return true;
                    }
                }
                return false;
            }
        };
        Collector rootIUs = sharedProfile.query(rootIUQuery, new Collector(), null);
        Profile userProfile = new Profile(id, null, sharedProfile.getProperties());
        userProfile.setSurrogateProfileHandler(this);
        Iterator iterator = rootIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            userProfile.addInstallableUnit(iu);
            userProfile.addInstallableUnitProperties(iu, sharedProfile.getInstallableUnitProperties(iu));
        }
        userProfile.setProperty(PROP_SURROGATE, Boolean.TRUE.toString());
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.INSTALL_FILTER);
        File installFolder = new File(installLocation.getURL().getPath());
        if (Boolean.valueOf(userProfile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
            userProfile.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.getAbsolutePath());
            userProfile.setProperty("org.eclipse.equinox.p2.cache.shared", installFolder.getAbsolutePath());
            userProfile.setProperty("org.eclipse.equinox.p2.roaming", Boolean.FALSE.toString());
        } else {
            String cache = userProfile.getProperty("org.eclipse.equinox.p2.cache");
            if (cache != null) {
                userProfile.setProperty("org.eclipse.equinox.p2.cache.shared", cache);
            }
        }
        BundleContext bundleContext2 = EngineActivator.getContext();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Location configurationLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName(), (String)Location.CONFIGURATION_FILTER);
        File configurationFolder = new File(configurationLocation.getURL().getPath());
        userProfile.setProperty("org.eclipse.equinox.p2.cache", configurationFolder.getParentFile().getAbsolutePath());
        userProfile.setProperty("org.eclipse.equinox.p2.configurationFolder", configurationFolder.getAbsolutePath());
        File launcherConfigFile = new File(configurationFolder, ECLIPSE_INI_IGNORED);
        userProfile.setProperty("org.eclipse.equinox.p2.launcherConfiguration", launcherConfigFile.getAbsolutePath());
        return userProfile;
    }

    public boolean isSurrogate(IProfile profile) {
        return Boolean.valueOf(profile.getProperty(PROP_SURROGATE));
    }

    public Collector queryProfile(IProfile profile, Query query, Collector collector, IProgressMonitor monitor) {
        IProfile sharedProfile = this.getProfileRegistry().getProfile(profile.getProfileId());
        if (sharedProfile != null) {
            sharedProfile.query(query, collector, monitor);
        }
        return profile.query(query, collector, monitor);
    }
}

