/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.RollbackOperationEvent;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MetadataCache {
    private static final String REPOSITORY_NAME = "Agent Metadata Cache";
    private ServiceReference busReference;
    private IProvisioningEventBus bus;
    private URL location;
    final ArrayList toAdd = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MetadataCache() {
        AgentLocation agentLocation;
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.location = (agentLocation = (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null ? agentLocation.getMetadataRepositoryURL() : null;
        this.hookListener();
    }

    IMetadataRepository getRepository() {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        try {
            return manager.loadRepository(this.location, null);
        }
        catch (ProvisionException provisionException) {
            try {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("p2.system", Boolean.TRUE.toString());
                IMetadataRepository repository = manager.createRepository(this.location, REPOSITORY_NAME, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
                manager.addRepository(repository.getLocation());
                return repository;
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalStateException(Messages.failed_creating_metadata_cache);
            }
        }
    }

    private void hookListener() {
        this.busReference = EngineActivator.getContext().getServiceReference(IProvisioningEventBus.SERVICE_NAME);
        this.bus = (IProvisioningEventBus)EngineActivator.getContext().getService(this.busReference);
        this.bus.addListener(new ProvisioningListener(){

            public void notify(EventObject o) {
                if (o instanceof InstallableUnitEvent) {
                    InstallableUnitEvent event = (InstallableUnitEvent)o;
                    if (event.isPre()) {
                        return;
                    }
                    if (event.isPost() && event.getResult().isOK() && event.isInstall()) {
                        IInstallableUnit installedIU = event.getOperand().second();
                        if (installedIU != null) {
                            MetadataCache.this.toAdd.add(installedIU.unresolved());
                        }
                        return;
                    }
                }
                if (o instanceof CommitOperationEvent) {
                    IInstallableUnit[] toAddArray = MetadataCache.this.toAdd.toArray(new IInstallableUnit[MetadataCache.this.toAdd.size()]);
                    MetadataCache.this.toAdd.clear();
                    MetadataCache.this.getRepository().addInstallableUnits(toAddArray);
                }
                if (o instanceof RollbackOperationEvent) {
                    MetadataCache.this.toAdd.clear();
                }
            }
        });
    }
}

