/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMapper;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class PackageFragmentRootInfo
extends OpenableElementInfo {
    protected SourceMapper sourceMapper = null;
    protected int fRootKind = 1;
    protected Object[] fNonJavaResources = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] computeFolderNonJavaResources(JavaProject project, IContainer folder, char[][] inclusionPatterns, char[][] exclusionPatterns) throws JavaModelException {
        Object[] nonJavaResources = new IResource[5];
        int nonJavaResourcesCounter = 0;
        try {
            block9: {
                IClasspathEntry[] classpath = project.getResolvedClasspath();
                IResource[] members = folder.members();
                int length = members.length;
                if (length <= 0) break block9;
                String sourceLevel = project.getOption("org.aspectj.org.eclipse.jdt.core.compiler.source", true);
                String complianceLevel = project.getOption("org.aspectj.org.eclipse.jdt.core.compiler.compliance", true);
                int i = 0;
                while (i < length) {
                    block10: {
                        IResource member = members[i];
                        switch (member.getType()) {
                            case 1: {
                                String fileName = member.getName();
                                if ((!Util.isValidCompilationUnitName(fileName, sourceLevel, complianceLevel) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) && !Util.isValidClassFileName(fileName, sourceLevel, complianceLevel) && (!org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(fileName) || !PackageFragmentRootInfo.isClasspathEntry(member.getFullPath(), classpath))) break;
                                break block10;
                            }
                            case 2: {
                                if (Util.isValidFolderNameForPackage(member.getName(), sourceLevel, complianceLevel) && (!Util.isExcluded(member, inclusionPatterns, exclusionPatterns) || PackageFragmentRootInfo.isClasspathEntry(member.getFullPath(), classpath))) break block10;
                            }
                        }
                        if (nonJavaResources.length == nonJavaResourcesCounter) {
                            Object[] objectArray = nonJavaResources;
                            nonJavaResources = new IResource[nonJavaResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                        }
                        nonJavaResources[nonJavaResourcesCounter++] = member;
                    }
                    ++i;
                }
            }
            if (nonJavaResources.length != nonJavaResourcesCounter) {
                Object[] objectArray = nonJavaResources;
                nonJavaResources = new IResource[nonJavaResourcesCounter];
                System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
            }
            return nonJavaResources;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    private Object[] computeNonJavaResources(IJavaProject project, IResource underlyingResource, PackageFragmentRoot handle) {
        Object[] nonJavaResources = JavaElementInfo.NO_NON_JAVA_RESOURCES;
        try {
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                nonJavaResources = PackageFragmentRootInfo.computeFolderNonJavaResources((JavaProject)project, (IContainer)underlyingResource, handle.fullInclusionPatternChars(), handle.fullExclusionPatternChars());
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return nonJavaResources;
    }

    synchronized Object[] getNonJavaResources(IJavaProject project, IResource underlyingResource, PackageFragmentRoot handle) {
        Object[] nonJavaResources = this.fNonJavaResources;
        if (nonJavaResources == null) {
            nonJavaResources = this.computeNonJavaResources(project, underlyingResource, handle);
            this.fNonJavaResources = nonJavaResources;
        }
        return nonJavaResources;
    }

    public int getRootKind() {
        return this.fRootKind;
    }

    protected SourceMapper getSourceMapper() {
        return this.sourceMapper;
    }

    private static boolean isClasspathEntry(IPath path, IClasspathEntry[] resolvedClasspath) {
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void setNonJavaResources(Object[] resources) {
        this.fNonJavaResources = resources;
    }

    protected void setRootKind(int newRootKind) {
        this.fRootKind = newRootKind;
    }

    protected void setSourceMapper(SourceMapper mapper) {
        this.sourceMapper = mapper;
    }
}

