/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class LongLiteral
extends NumberLiteral {
    static final Constant FORMAT_ERROR = DoubleConstant.fromValue(Double.POSITIVE_INFINITY);

    public LongLiteral(char[] token, int s, int e) {
        super(token, s, e);
    }

    public void computeConstant() {
        long computedValue;
        int length = this.source.length - 1;
        if (this.source[0] == '0') {
            int digitValue;
            int radix;
            int j;
            int shift;
            if (length == 1) {
                this.constant = LongConstant.fromValue(0L);
                return;
            }
            if (this.source[1] == 'x' || this.source[1] == 'X') {
                shift = 4;
                j = 2;
                radix = 16;
            } else {
                shift = 3;
                j = 1;
                radix = 8;
            }
            int nbDigit = 0;
            while (this.source[j] == '0') {
                if (++j != length) continue;
                this.constant = LongConstant.fromValue(0L);
                return;
            }
            if ((digitValue = ScannerHelper.digit(this.source[j++], radix)) < 0) {
                this.constant = FORMAT_ERROR;
                return;
            }
            nbDigit = digitValue >= 8 ? 4 : (digitValue >= 4 ? 3 : (digitValue >= 2 ? 2 : 1));
            computedValue = digitValue;
            while (j < length) {
                if ((digitValue = ScannerHelper.digit(this.source[j++], radix)) < 0) {
                    this.constant = FORMAT_ERROR;
                    return;
                }
                if ((nbDigit += shift) > 64) {
                    return;
                }
                computedValue = computedValue << shift | (long)digitValue;
            }
        } else {
            long previous = 0L;
            computedValue = 0L;
            long limit = 0xCCCCCCCCCCCCCCCL;
            int i = 0;
            while (i < length) {
                int digitValue = ScannerHelper.digit(this.source[i], 10);
                if (digitValue < 0) {
                    return;
                }
                previous = computedValue;
                if (computedValue > 0xCCCCCCCCCCCCCCCL) {
                    return;
                }
                if ((computedValue *= 10L) + (long)digitValue > Long.MAX_VALUE) {
                    return;
                }
                if (previous > (computedValue += (long)digitValue)) {
                    return;
                }
                ++i;
            }
        }
        this.constant = LongConstant.fromValue(computedValue);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope scope) {
        return TypeBinding.LONG;
    }

    public final boolean mayRepresentMIN_VALUE() {
        return this.source.length == 20 && this.source[0] == '9' && this.source[1] == '2' && this.source[2] == '2' && this.source[3] == '3' && this.source[4] == '3' && this.source[5] == '7' && this.source[6] == '2' && this.source[7] == '0' && this.source[8] == '3' && this.source[9] == '6' && this.source[10] == '8' && this.source[11] == '5' && this.source[12] == '4' && this.source[13] == '7' && this.source[14] == '7' && this.source[15] == '5' && this.source[16] == '8' && this.source[17] == '0' && this.source[18] == '8' && (this.bits & 0x1FE00000) >> 21 == 0;
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding tb = super.resolveType(scope);
        if (this.constant == FORMAT_ERROR) {
            this.constant = Constant.NotAConstant;
            scope.problemReporter().constantOutOfFormat(this);
            this.resolvedType = null;
            return null;
        }
        return tb;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

