/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import org.aspectj.ajdt.internal.compiler.lookup.EclipseAnnotationConvertor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class EclipseResolvedMember
extends ResolvedMemberImpl {
    private static String[] NO_ARGS = new String[0];
    private Binding realBinding;
    private String[] argumentNames;
    private World w;
    private ResolvedType[] cachedAnnotationTypes;
    private EclipseFactory eclipseFactory;

    public EclipseResolvedMember(MethodBinding binding, Member.Kind memberKind, ResolvedType realDeclaringType, int modifiers, UnresolvedType type, String string, UnresolvedType[] types, UnresolvedType[] types2, EclipseFactory eclipseFactory) {
        super(memberKind, (UnresolvedType)realDeclaringType, modifiers, type, string, types, types2);
        this.realBinding = binding;
        this.eclipseFactory = eclipseFactory;
        this.w = realDeclaringType.getWorld();
    }

    public EclipseResolvedMember(FieldBinding binding, Member.Kind field, ResolvedType realDeclaringType, int modifiers, ResolvedType type, String string, UnresolvedType[] none) {
        super(field, (UnresolvedType)realDeclaringType, modifiers, (UnresolvedType)type, string, none);
        this.realBinding = binding;
        this.w = realDeclaringType.getWorld();
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        ResolvedType[] annotationTypes = this.getAnnotationTypes();
        if (annotationTypes == null) {
            return false;
        }
        for (int i = 0; i < annotationTypes.length; ++i) {
            ResolvedType type = annotationTypes[i];
            if (!type.equals((Object)ofType)) continue;
            return true;
        }
        return false;
    }

    public AnnotationX[] getAnnotations() {
        long abits = this.realBinding.getAnnotationTagBits();
        Annotation[] annos = this.getEclipseAnnotations();
        if (annos == null) {
            return null;
        }
        throw new RuntimeException("not yet implemented - please raise an AJ bug");
    }

    public AnnotationX getAnnotationOfType(UnresolvedType ofType) {
        long abits = this.realBinding.getAnnotationTagBits();
        Annotation[] annos = this.getEclipseAnnotations();
        if (annos == null) {
            return null;
        }
        for (int i = 0; i < annos.length; ++i) {
            Annotation anno = annos[i];
            UnresolvedType ut = UnresolvedType.forSignature((String)new String(anno.resolvedType.signature()));
            if (!this.w.resolve(ut).equals((Object)ofType)) continue;
            return EclipseAnnotationConvertor.convertEclipseAnnotation(anno, this.w, this.eclipseFactory);
        }
        return null;
    }

    public String getAnnotationDefaultValue() {
        AbstractMethodDeclaration methodDecl;
        if (this.realBinding instanceof MethodBinding && (methodDecl = this.getTypeDeclaration().declarationOf((MethodBinding)this.realBinding)) instanceof AnnotationMethodDeclaration) {
            AnnotationMethodDeclaration annoMethodDecl = (AnnotationMethodDeclaration)methodDecl;
            Expression e = annoMethodDecl.defaultValue;
            if (e.resolvedType == null) {
                e.resolve(methodDecl.scope);
            }
            if (e instanceof QualifiedNameReference) {
                QualifiedNameReference qnr = (QualifiedNameReference)e;
                if (qnr.binding instanceof FieldBinding) {
                    FieldBinding fb = (FieldBinding)qnr.binding;
                    StringBuffer sb = new StringBuffer();
                    sb.append(fb.declaringClass.signature());
                    sb.append(fb.name);
                    return sb.toString();
                }
            }
        }
        return null;
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.cachedAnnotationTypes == null) {
            long abits = this.realBinding.getAnnotationTagBits();
            Annotation[] annos = this.getEclipseAnnotations();
            if (annos == null) {
                this.cachedAnnotationTypes = ResolvedType.EMPTY_RESOLVED_TYPE_ARRAY;
            } else {
                this.cachedAnnotationTypes = new ResolvedType[annos.length];
                for (int i = 0; i < annos.length; ++i) {
                    Annotation type = annos[i];
                    this.cachedAnnotationTypes[i] = this.w.resolve(UnresolvedType.forSignature((String)new String(type.resolvedType.signature())));
                }
            }
        }
        return this.cachedAnnotationTypes;
    }

    public String[] getParameterNames() {
        if (this.argumentNames != null) {
            return this.argumentNames;
        }
        if (this.realBinding instanceof FieldBinding) {
            this.argumentNames = NO_ARGS;
        } else {
            Argument[] args;
            TypeDeclaration typeDecl = this.getTypeDeclaration();
            AbstractMethodDeclaration methodDecl = typeDecl.declarationOf((MethodBinding)this.realBinding);
            Argument[] argumentArray = args = methodDecl == null ? null : methodDecl.arguments;
            if (args == null) {
                this.argumentNames = NO_ARGS;
            } else {
                this.argumentNames = new String[args.length];
                for (int i = 0; i < this.argumentNames.length; ++i) {
                    this.argumentNames[i] = new String(methodDecl.arguments[i].name);
                }
            }
        }
        return this.argumentNames;
    }

    private Annotation[] getEclipseAnnotations() {
        if (this.realBinding instanceof MethodBinding) {
            AbstractMethodDeclaration methodDecl = this.getTypeDeclaration().declarationOf((MethodBinding)this.realBinding);
            return methodDecl.annotations;
        }
        if (this.realBinding instanceof FieldBinding) {
            FieldDeclaration fieldDecl = this.getTypeDeclaration().declarationOf((FieldBinding)this.realBinding);
            return fieldDecl.annotations;
        }
        return null;
    }

    private TypeDeclaration getTypeDeclaration() {
        if (this.realBinding instanceof MethodBinding) {
            return ((SourceTypeBinding)((MethodBinding)this.realBinding).declaringClass).scope.referenceContext;
        }
        if (this.realBinding instanceof FieldBinding) {
            return ((SourceTypeBinding)((FieldBinding)this.realBinding).declaringClass).scope.referenceContext;
        }
        return null;
    }
}

