/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.view;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import pl.poznan.put.qjunit.view.MutationsView;
import pl.poznan.put.qjunit.view.OpenEditorAction;

public class OpenTestAction
extends OpenEditorAction {
    private String fMethodName;
    private ISourceRange fRange;
    private int fLineNumber;

    public OpenTestAction(MutationsView testRunner, String className, String method, int lineNumber) {
        this(testRunner, className, method, true);
        this.fLineNumber = lineNumber;
    }

    public OpenTestAction(MutationsView testRunner, String className, String method) {
        this(testRunner, className, method, true);
    }

    public OpenTestAction(MutationsView testRunner, String className) {
        this(testRunner, className, null, 0);
    }

    public OpenTestAction(MutationsView testRunner, String className, String method, boolean activate) {
        super(testRunner, className, activate);
        this.fMethodName = method;
    }

    protected IJavaElement findElement(IJavaProject project, String className) throws JavaModelException {
        IType type = this.findType(project, className);
        if (type == null) {
            return null;
        }
        if (this.fMethodName == null) {
            return type;
        }
        IMethod method = this.findMethod(type);
        if (method == null) {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] types = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < types.length) {
                method = this.findMethod(types[i]);
                if (method != null) break;
                ++i;
            }
        }
        if (method == null) {
            String title = "Go To Test";
            String message = MessageFormat.format("Method '{0}' not found. Opening test class.", this.fMethodName);
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return type;
        }
        this.fRange = method.getNameRange();
        return method;
    }

    IMethod findMethod(IType type) {
        IStatus status = JavaConventions.validateMethodName((String)this.fMethodName, (String)"1.3", (String)"1.3");
        if (!status.isOK()) {
            return null;
        }
        IMethod method = type.getMethod(this.fMethodName, new String[0]);
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber > 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(this.fLineNumber - 1), document.getLineLength(this.fLineNumber - 1));
            }
            catch (BadLocationException badLocationException) {}
        } else if (this.fRange != null) {
            textEditor.selectAndReveal(this.fRange.getOffset(), this.fRange.getLength());
        }
    }
}

