/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.debug.ui.launchConfigurations.AbstractVMInstallPage;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.StandardVMPage;
import org.eclipse.jdt.internal.debug.ui.jres.VMInstallWizard;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class VMTypePage
extends WizardPage {
    private ListViewer fTypesViewer;
    private AbstractVMInstallPage fNextPage;
    private Set fPages = new HashSet();

    public VMTypePage() {
        super(JREMessages.VMTypePage_0);
        this.setDescription(JREMessages.VMTypePage_1);
        this.setTitle(JREMessages.VMTypePage_2);
    }

    public void dispose() {
        super.dispose();
        Iterator iterator = this.fPages.iterator();
        while (iterator.hasNext()) {
            AbstractVMInstallPage page = (AbstractVMInstallPage)((Object)iterator.next());
            page.dispose();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SWTFactory.createLabel(composite, JREMessages.VMTypePage_3, 1);
        this.fTypesViewer = new ListViewer(composite, 2052);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTypesViewer.getControl().setLayoutData((Object)data);
        this.fTypesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTypesViewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.fTypesViewer.setComparator(new ViewerComparator());
        this.fTypesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                VMTypePage.this.setPageComplete(true);
                VMTypePage.this.updateNextPage();
                VMTypePage.this.getWizard().getContainer().showPage(VMTypePage.this.getNextPage());
            }
        });
        this.fTypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    VMTypePage.this.setPageComplete(false);
                } else {
                    VMTypePage.this.setPageComplete(true);
                    VMTypePage.this.updateNextPage();
                }
            }
        });
        this.fTypesViewer.setInput((Object)JavaRuntime.getVMInstallTypes());
        this.setControl((Control)composite);
        this.fTypesViewer.setSelection((ISelection)new StructuredSelection((Object)JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType")));
        this.updateNextPage();
    }

    public Image getImage() {
        return JavaDebugImages.get("IMG_WIZBAN_LIBRARY");
    }

    public IWizardPage getNextPage() {
        return this.fNextPage;
    }

    private void updateNextPage() {
        IStructuredSelection selection;
        if (this.isPageComplete() && !(selection = (IStructuredSelection)this.fTypesViewer.getSelection()).isEmpty()) {
            IVMInstallType installType = (IVMInstallType)selection.getFirstElement();
            AbstractVMInstallPage page = ((VMInstallWizard)this.getWizard()).getPage(installType);
            page.setWizard(this.getWizard());
            VMStandin standin = new VMStandin(installType, StandardVMPage.createUniqueId(installType));
            standin.setName("");
            page.setSelection(standin);
            this.fNextPage = page;
            this.fPages.add(page);
        }
    }

    private class TypeLabelProvider
    extends LabelProvider {
        private TypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IVMInstallType) {
                IVMInstallType type = (IVMInstallType)element;
                return type.getName();
            }
            return super.getText(element);
        }
    }
}

