/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.ui.launchConfigurations.AbstractVMInstallPage;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.VMLibraryBlock;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StandardVMPage
extends AbstractVMInstallPage {
    private VMStandin fVM;
    private Text fVMName;
    private Text fVMArgs;
    private Text fJRERoot;
    private VMLibraryBlock fLibraryBlock;
    private URL fJavadocLocation = null;
    private boolean fAutoDetectAttributes = false;
    private IStatus[] fFieldStatus = new IStatus[1];

    public StandardVMPage() {
        super(JREMessages.StandardVMPage_0);
        int i = 0;
        while (i < this.fFieldStatus.length) {
            this.fFieldStatus[i] = Status.OK_STATUS;
            ++i;
        }
    }

    public Image getImage() {
        return JavaDebugImages.get("IMG_WIZBAN_LIBRARY");
    }

    public void createControl(Composite p) {
        Composite composite = new Composite(p, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SWTFactory.createLabel(composite, JREMessages.addVMDialog_jreHome, 1);
        this.fJRERoot = SWTFactory.createSingleText(composite, 1);
        Button folders = SWTFactory.createPushButton(composite, JREMessages.AddVMDialog_22, null);
        GridData data = (GridData)folders.getLayoutData();
        data.horizontalAlignment = 3;
        SWTFactory.createLabel(composite, JREMessages.addVMDialog_jreName, 1);
        this.fVMName = SWTFactory.createSingleText(composite, 2);
        SWTFactory.createLabel(composite, JREMessages.AddVMDialog_23, 1);
        this.fVMArgs = SWTFactory.createSingleText(composite, 2);
        SWTFactory.createLabel(composite, JREMessages.AddVMDialog_JRE_system_libraries__1, 3);
        this.fLibraryBlock = new VMLibraryBlock();
        this.fLibraryBlock.setWizard(this.getWizard());
        this.fLibraryBlock.createControl(composite);
        Control libControl = this.fLibraryBlock.getControl();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        libControl.setLayoutData((Object)gd);
        this.fVMName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardVMPage.this.validateVMName();
            }
        });
        this.fJRERoot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardVMPage.this.validateJRELocation();
            }
        });
        folders.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(StandardVMPage.this.getShell());
                File file = new File(StandardVMPage.this.fJRERoot.getText());
                String text = StandardVMPage.this.fJRERoot.getText();
                if (file.isFile()) {
                    text = file.getParentFile().getAbsolutePath();
                }
                dialog.setFilterPath(text);
                dialog.setMessage(JREMessages.addVMDialog_pickJRERootDialog_message);
                String newPath = dialog.open();
                if (newPath != null) {
                    StandardVMPage.this.fJRERoot.setText(newPath);
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.initializeFields();
    }

    private void validateJRELocation() {
        String name;
        String locationName = this.fJRERoot.getText();
        StatusInfo s = null;
        File file = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(2, JREMessages.addVMDialog_enterLocation);
        } else {
            file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, JREMessages.addVMDialog_locationNotExists);
            } else {
                final IStatus[] temp = new IStatus[1];
                final File tempFile = file;
                Runnable r = new Runnable(){

                    public void run() {
                        temp[0] = StandardVMPage.this.fVM.getVMInstallType().validateInstallLocation(tempFile);
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
            }
        }
        if (file != null) {
            this.fVM.setInstallLocation(file);
        }
        if (s.isOK() && file != null && ((name = this.fVMName.getText()) == null || name.trim().length() == 0)) {
            if (file.isFile()) {
                String fileName = file.getName();
                int index = fileName.lastIndexOf(".ee");
                if (index > 0) {
                    fileName = fileName.substring(0, index);
                }
                this.fVMName.setText(fileName);
            } else {
                try {
                    String genName = null;
                    Path path = new Path(file.getCanonicalPath());
                    int segs = path.segmentCount();
                    if (segs == 1) {
                        genName = path.segment(0);
                    } else if (segs >= 2) {
                        String last = path.lastSegment();
                        genName = "jre".equalsIgnoreCase(last) ? path.segment(segs - 2) : last;
                    }
                    if (genName != null) {
                        this.fVMName.setText(genName);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.detectJavadocLocation();
        this.setJRELocationStatus(s);
        this.fLibraryBlock.setSelection(this.fVM);
        this.updatePageStatus();
    }

    private void detectJavadocLocation() {
        if (this.fAutoDetectAttributes) {
            IVMInstallType type = this.fVM.getVMInstallType();
            if (type instanceof AbstractVMInstallType) {
                AbstractVMInstallType atype = (AbstractVMInstallType)type;
                this.fJavadocLocation = atype.getDefaultJavadocLocation(this.getInstallLocation());
                String args = atype.getDefaultVMArguments(this.getInstallLocation());
                if (args != null) {
                    this.fVMArgs.setText(args);
                }
            }
        } else {
            this.fJavadocLocation = this.fVM.getJavadocLocation();
        }
    }

    protected File getInstallLocation() {
        return new File(this.fJRERoot.getText());
    }

    private void validateVMName() {
        this.nameChanged(this.fVMName.getText());
    }

    public boolean finish() {
        this.setFieldValuesToVM(this.fVM);
        this.fLibraryBlock.finish();
        return true;
    }

    public VMStandin getSelection() {
        return this.fVM;
    }

    public void setSelection(VMStandin vm) {
        super.setSelection(vm);
        this.fVM = vm;
        this.fAutoDetectAttributes = vm.getJavadocLocation() == null;
        this.setTitle(JREMessages.StandardVMPage_1);
        this.setDescription(JREMessages.StandardVMPage_2);
    }

    protected void setFieldValuesToVM(VMStandin vm) {
        File dir = new File(this.fJRERoot.getText());
        try {
            vm.setInstallLocation(dir.getCanonicalFile());
        }
        catch (IOException iOException) {
            vm.setInstallLocation(dir.getAbsoluteFile());
        }
        vm.setName(this.fVMName.getText());
        vm.setJavadocLocation(this.getURL());
        String argString = this.fVMArgs.getText().trim();
        if (argString != null && argString.length() > 0) {
            vm.setVMArgs(argString);
        } else {
            vm.setVMArgs(null);
        }
    }

    protected URL getURL() {
        return this.fJavadocLocation;
    }

    protected static String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    private void initializeFields() {
        String vmArgs;
        this.fLibraryBlock.setSelection(this.fVM);
        this.fVMName.setText(this.fVM.getName());
        File installLocation = this.fVM.getInstallLocation();
        if (installLocation != null) {
            this.fJRERoot.setText(installLocation.getAbsolutePath());
        }
        if ((vmArgs = this.fVM.getVMArgs()) != null) {
            this.fVMArgs.setText(vmArgs);
        }
        this.validateVMName();
        this.validateJRELocation();
    }

    private void setJRELocationStatus(IStatus status) {
        this.fFieldStatus[0] = status;
    }

    public String getErrorMessage() {
        String message = super.getErrorMessage();
        if (message == null) {
            return this.fLibraryBlock.getErrorMessage();
        }
        return message;
    }

    public boolean isPageComplete() {
        boolean complete = super.isPageComplete();
        if (complete) {
            return this.fLibraryBlock.isPageComplete();
        }
        return complete;
    }

    protected IStatus[] getVMStatus() {
        return this.fFieldStatus;
    }
}

