/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.ui.launchConfigurations.AbstractVMInstallPage;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.VMLibraryBlock;
import org.eclipse.jdt.internal.launching.EEVMType;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EEVMPage
extends AbstractVMInstallPage {
    private VMStandin fVM;
    private Text fVMName;
    private Text fVMArgs;
    private Text fEEFile;
    private VMLibraryBlock fLibraryBlock;
    private IStatus[] fFieldStatus = new IStatus[1];
    private boolean fIgnoreCallbacks = false;

    public EEVMPage() {
        super(JREMessages.EEVMPage_0);
        int i = 0;
        while (i < this.fFieldStatus.length) {
            this.fFieldStatus[i] = Status.OK_STATUS;
            ++i;
        }
    }

    public Image getImage() {
        return JavaDebugImages.get("IMG_WIZBAN_LIBRARY");
    }

    public void createControl(Composite p) {
        Composite composite = new Composite(p, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SWTFactory.createLabel(composite, JREMessages.EEVMPage_1, 1);
        this.fEEFile = SWTFactory.createSingleText(composite, 1);
        Button folders = SWTFactory.createPushButton(composite, JREMessages.EEVMPage_2, null);
        GridData data = (GridData)folders.getLayoutData();
        data.horizontalAlignment = 3;
        SWTFactory.createLabel(composite, JREMessages.addVMDialog_jreName, 1);
        this.fVMName = SWTFactory.createSingleText(composite, 2);
        Label label = SWTFactory.createLabel(composite, JREMessages.AddVMDialog_23, 2);
        GridData gd = (GridData)label.getLayoutData();
        gd.verticalAlignment = 1;
        this.fVMArgs = SWTFactory.createText(composite, 2624, 3, "");
        gd = (GridData)this.fVMArgs.getLayoutData();
        gd.widthHint = 200;
        gd.heightHint = 75;
        SWTFactory.createLabel(composite, JREMessages.AddVMDialog_JRE_system_libraries__1, 3);
        this.fLibraryBlock = new VMLibraryBlock();
        this.fLibraryBlock.setWizard(this.getWizard());
        this.fLibraryBlock.createControl(composite);
        Control libControl = this.fLibraryBlock.getControl();
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        libControl.setLayoutData((Object)gd);
        this.initializeFields();
        this.fVMName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!EEVMPage.this.fIgnoreCallbacks) {
                    EEVMPage.this.validateVMName();
                }
            }
        });
        this.fEEFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!EEVMPage.this.fIgnoreCallbacks && EEVMPage.this.validateDefinitionFile().isOK()) {
                    EEVMPage.this.reloadDefinitionFile();
                }
            }
        });
        folders.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EEVMPage.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.ee"});
                File file = EEVMPage.this.getDefinitionFile();
                String text = EEVMPage.this.fEEFile.getText();
                if (file != null && file.isFile()) {
                    text = file.getParentFile().getAbsolutePath();
                }
                dialog.setFileName(text);
                String newPath = dialog.open();
                if (newPath != null) {
                    EEVMPage.this.fEEFile.setText(newPath);
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private IStatus validateDefinitionFile() {
        String locationName = this.fEEFile.getText();
        StatusInfo s = null;
        File file = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(2, JREMessages.EEVMPage_4);
        } else {
            file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, JREMessages.EEVMPage_5);
            } else {
                EEVMType.clearProperties((File)file);
                final IStatus[] temp = new IStatus[1];
                final VMStandin[] vm = new VMStandin[1];
                final File tempFile = file;
                Runnable r = new Runnable(){

                    public void run() {
                        try {
                            vm[0] = JavaRuntime.createVMFromDefinitionFile((File)tempFile, (String)EEVMPage.this.fVM.getName(), (String)EEVMPage.this.fVM.getId());
                            IStatus status = vm[0].getVMInstallType().validateInstallLocation(vm[0].getInstallLocation());
                            temp[0] = status.getSeverity() != 4 ? Status.OK_STATUS : status;
                        }
                        catch (CoreException e) {
                            temp[0] = e.getStatus();
                        }
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
            }
        }
        this.setDefinitionFileStatus(s);
        this.updatePageStatus();
        return s;
    }

    private void reloadDefinitionFile() {
        IStatus s = Status.OK_STATUS;
        File file = this.getDefinitionFile();
        if (file != null && file.exists()) {
            final IStatus[] temp = new IStatus[1];
            final VMStandin[] vm = new VMStandin[1];
            final File tempFile = file;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        vm[0] = JavaRuntime.createVMFromDefinitionFile((File)tempFile, (String)EEVMPage.this.fVM.getName(), (String)EEVMPage.this.fVM.getId());
                        temp[0] = Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        temp[0] = e.getStatus();
                    }
                }
            };
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
            s = temp[0];
            if (s.isOK()) {
                this.fVM = vm[0];
            }
        }
        if (s.isOK() && file != null) {
            this.initializeFields();
        }
        this.setDefinitionFileStatus(s);
    }

    private void validateVMName() {
        this.nameChanged(this.fVMName.getText());
    }

    public boolean finish() {
        this.setFieldValuesToVM(this.fVM);
        this.fLibraryBlock.finish();
        return true;
    }

    public VMStandin getSelection() {
        return this.fVM;
    }

    public void setSelection(VMStandin vm) {
        super.setSelection(vm);
        this.fVM = vm;
        this.setTitle(JREMessages.EEVMPage_6);
        this.setDescription(JREMessages.EEVMPage_7);
    }

    protected void setFieldValuesToVM(VMStandin vm) {
        File eeFile = this.getDefinitionFile();
        File home = null;
        if (eeFile != null) {
            vm.setAttribute("ATTR_DEFINITION_FILE", eeFile.getPath());
            String homePath = EEVMType.getProperty((String)"-Djava.home", (File)eeFile);
            if (homePath != null) {
                home = new File(homePath);
                try {
                    home = home.getCanonicalFile();
                }
                catch (IOException iOException) {}
            }
        }
        vm.setInstallLocation(home);
        vm.setName(this.fVMName.getText());
        String argString = this.fVMArgs.getText().trim();
        if (argString != null && argString.length() > 0) {
            vm.setVMArgs(argString);
        } else {
            vm.setVMArgs(null);
        }
    }

    private File getDefinitionFile() {
        String path = this.fEEFile.getText().trim();
        if (path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    protected static String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    private void initializeFields() {
        try {
            String vmArgs;
            this.fIgnoreCallbacks = true;
            this.fLibraryBlock.setSelection(this.fVM);
            this.fVMName.setText(this.fVM.getName());
            String eePath = this.fVM.getAttribute("ATTR_DEFINITION_FILE");
            if (eePath != null) {
                this.fEEFile.setText(eePath);
            }
            if ((vmArgs = this.fVM.getVMArgs()) != null) {
                this.fVMArgs.setText(vmArgs);
            }
            this.validateVMName();
            this.validateDefinitionFile();
        }
        finally {
            this.fIgnoreCallbacks = false;
        }
    }

    private void setDefinitionFileStatus(IStatus status) {
        this.fFieldStatus[0] = status;
    }

    public String getErrorMessage() {
        String message = super.getErrorMessage();
        if (message == null) {
            return this.fLibraryBlock.getErrorMessage();
        }
        return message;
    }

    public boolean isPageComplete() {
        boolean complete = super.isPageComplete();
        if (complete) {
            return this.fLibraryBlock.isPageComplete();
        }
        return complete;
    }

    protected IStatus[] getVMStatus() {
        return this.fFieldStatus;
    }
}

