/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.metadata.generator.features.FeatureParser;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.Messages;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.RepositoryListener;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.BundleDescriptionFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.FeatureEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SiteListener
extends RepositoryListener {
    public static final String SITE_POLICY = "org.eclipse.update.site.policy";
    public static final String SITE_LIST = "org.eclipse.update.site.list";
    private static final String FEATURES = "features";
    private static final String PLUGINS = "plugins";
    private String policy;
    private String[] list;
    private String url;
    private DirectoryChangeListener delegate;
    private String[] managedFiles;
    static /* synthetic */ Class class$0;

    private static boolean contains(String[] plugins, File file) {
        String filename = file.getAbsolutePath();
        int i = 0;
        while (i < plugins.length) {
            if (filename.endsWith(new File(plugins[i]).toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SiteListener(Map properties, String url, DirectoryChangeListener delegate) {
        super(Activator.getContext(), url, null, true);
        this.url = url;
        this.delegate = delegate;
        this.policy = (String)properties.get(SITE_POLICY);
        HashSet<String> listCollection = new HashSet<String>();
        String listString = (String)properties.get(SITE_LIST);
        if (listString != null) {
            StringTokenizer tokenizer = new StringTokenizer(listString, ",");
            while (tokenizer.hasMoreTokens()) {
                listCollection.add(tokenizer.nextToken());
            }
        }
        this.list = listCollection.toArray(new String[listCollection.size()]);
    }

    public boolean isInterested(File file) {
        if (!this.delegate.isInterested(file) || !super.isInterested(file)) {
            return false;
        }
        if ("MANAGED-ONLY".equals(this.policy)) {
            return SiteListener.contains(this.getManagedFiles(), file);
        }
        if ("USER-EXCLUDE".equals(this.policy)) {
            return this.list.length == 0 ? true : !SiteListener.contains(this.list, file);
        }
        if ("USER-INCLUDE".equals(this.policy)) {
            return this.list.length == 0 ? false : SiteListener.contains(this.list, file);
        }
        return false;
    }

    private String[] getManagedFiles() {
        File siteLocation;
        if (this.managedFiles != null) {
            return this.managedFiles;
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            siteLocation = URLUtil.toFile((URL)new URL(this.url));
        }
        catch (MalformedURLException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", "Unable to create a URL from site locatin: " + this.url, (Throwable)e));
            return new String[0];
        }
        Map pluginCache = this.getPlugins(siteLocation);
        Map featureCache = this.getFeatures(siteLocation);
        Iterator iter = featureCache.keySet().iterator();
        while (iter.hasNext()) {
            File featureFile = (File)iter.next();
            result.add(featureFile.toString());
            Feature feature = (Feature)featureCache.get(featureFile);
            FeatureEntry[] entries = feature.getEntries();
            int inner = 0;
            while (inner < entries.length) {
                FeatureEntry entry = entries[inner];
                String key = String.valueOf(entry.getId()) + '/' + entry.getVersion();
                File pluginLocation = (File)pluginCache.get(key);
                if (pluginLocation != null) {
                    result.add(pluginLocation.toString());
                }
                ++inner;
            }
        }
        this.managedFiles = result.toArray(new String[result.size()]);
        return this.managedFiles;
    }

    private Map getFeatures(File siteLocation) {
        HashMap<File, Feature> result = new HashMap<File, Feature>();
        File featureDir = new File(siteLocation, FEATURES);
        File[] children = featureDir.listFiles();
        int i = 0;
        while (i < children.length) {
            FeatureParser parser = new FeatureParser();
            File child = children[i];
            Feature entry = parser.parse(child);
            if (entry != null) {
                result.put(child, entry);
            }
            ++i;
        }
        return result;
    }

    private Map getPlugins(File siteLocation) {
        ServiceReference reference;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = bundleContext.getServiceReference(clazz.getName())) == null) {
            throw new IllegalStateException(Messages.platformadmin_not_registered);
        }
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)Activator.getContext().getService(reference);
            if (platformAdmin == null) {
                throw new IllegalStateException(Messages.platformadmin_not_registered);
            }
            StateObjectFactory stateObjectFactory = platformAdmin.getFactory();
            BundleDescriptionFactory factory = new BundleDescriptionFactory(stateObjectFactory, null);
            File[] plugins = new File(siteLocation, PLUGINS).listFiles();
            HashMap<String, File> result = new HashMap<String, File>();
            int i = 0;
            while (plugins != null && i < plugins.length) {
                File bundleLocation = plugins[i];
                BundleDescription description = factory.getBundleDescription(bundleLocation);
                String id = description.getSymbolicName();
                String version = description.getVersion().toString();
                result.put(String.valueOf(id) + '/' + version, bundleLocation);
                ++i;
            }
            HashMap<String, File> hashMap = result;
            return hashMap;
        }
        finally {
            Activator.getContext().ungetService(reference);
        }
    }

    public boolean added(File file) {
        return this.delegate.added(file);
    }

    public boolean changed(File file) {
        return this.delegate.changed(file);
    }

    public Long getSeenFile(File file) {
        return this.delegate.getSeenFile(file);
    }

    public boolean removed(File file) {
        return this.delegate.removed(file);
    }

    public void startPoll() {
        this.delegate.startPoll();
    }

    public void stopPoll() {
        this.delegate.stopPoll();
    }
}

