/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.IMetadataRepositoryFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.osgi.util.NLS;

public class ExtensionLocationMetadataRepositoryFactory
implements IMetadataRepositoryFactory {
    public IMetadataRepository create(URL location, String name, String type, Map properties) throws ProvisionException {
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URL repoLocation = ExtensionLocationMetadataRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        try {
            new SimpleMetadataRepositoryFactory().load(repoLocation, null);
            String msg = NLS.bind((String)Messages.repo_already_exists, (Object)location.toExternalForm());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1001, msg, null));
        }
        catch (ProvisionException provisionException) {
            IMetadataRepository repository = new SimpleMetadataRepositoryFactory().create(repoLocation, name, null, properties);
            return new ExtensionLocationMetadataRepository(location, repository, null);
        }
    }

    public IMetadataRepository load(URL location, IProgressMonitor monitor) throws ProvisionException {
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URL repoLocation = ExtensionLocationMetadataRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        try {
            IMetadataRepository repository = new SimpleMetadataRepositoryFactory().load(repoLocation, null);
            return new ExtensionLocationMetadataRepository(location, repository, monitor);
        }
        catch (ProvisionException provisionException) {
            return this.create(location, "Extension location repository: " + location.toExternalForm(), "org.eclipse.equinox.p2.extensionlocation.metadataRepository", null);
        }
    }

    public IStatus validate(URL location, IProgressMonitor monitor) {
        try {
            ExtensionLocationMetadataRepository.validate(location, monitor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }
}

