/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.BundlePoolFilteredListener;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.p2.extensionlocation.SiteListener;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryWatcher;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.RepositoryListener;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.AbstractMetadataRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ExtensionLocationMetadataRepository
extends AbstractMetadataRepository {
    public static final String TYPE = "org.eclipse.equinox.p2.extensionlocation.metadataRepository";
    private static final String EXTENSION_LOCATION = ".eclipseextension";
    private static final String SITE_XML = "site.xml";
    private static final String ECLIPSE = "eclipse";
    private static final String FEATURES = "features";
    private static final String PLUGINS = "plugins";
    private static final String FILE = "file";
    private IMetadataRepository metadataRepository;

    public static URL getLocalRepositoryLocation(URL location) {
        BundleContext context = Activator.getContext();
        String stateDirName = Integer.toString(location.toExternalForm().hashCode());
        File bundleData = context.getDataFile(null);
        File stateDir = new File(bundleData, stateDirName);
        try {
            return stateDir.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ExtensionLocationMetadataRepository(URL location, IMetadataRepository repository, IProgressMonitor monitor) throws ProvisionException {
        super("Extension: " + location.toExternalForm(), null, null, location, null, null, null);
        this.metadataRepository = repository;
        File base = ExtensionLocationMetadataRepository.getBaseDirectory(location);
        File plugins = new File(base, PLUGINS);
        File features = new File(base, FEATURES);
        DirectoryWatcher watcher = new DirectoryWatcher(new File[]{plugins, features});
        RepositoryListener listener = new RepositoryListener(Activator.getContext(), this.metadataRepository, null);
        if (this.getProperties().get("org.eclipse.update.site.policy") != null) {
            listener = new SiteListener(this.getProperties(), location.toExternalForm(), new BundlePoolFilteredListener((DirectoryChangeListener)listener));
        }
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
    }

    public void addInstallableUnits(IInstallableUnit[] installableUnits) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public boolean removeInstallableUnits(Query query, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        return this.metadataRepository.query(query, collector, monitor);
    }

    public static void validate(URL location, IProgressMonitor monitor) throws ProvisionException {
        File base = ExtensionLocationMetadataRepository.getBaseDirectory(location);
        if (new File(base, EXTENSION_LOCATION).exists()) {
            return;
        }
        if (new File(base, SITE_XML).exists()) {
            String message = NLS.bind((String)Messages.error_update_site, (Object)location.toExternalForm());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, message, null));
        }
    }

    public static File getBaseDirectory(URL url) throws ProvisionException {
        if (!FILE.equals(url.getProtocol())) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, Messages.not_file_protocol, null));
        }
        String path = url.getPath();
        File base = new File(path);
        if (!base.isDirectory()) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_directory, (Object)url.toExternalForm()), null));
        }
        if (ExtensionLocationMetadataRepository.isBaseDirectory(base)) {
            return base;
        }
        File eclipseBase = new File(base, ECLIPSE);
        if (ExtensionLocationMetadataRepository.isBaseDirectory(eclipseBase)) {
            return eclipseBase;
        }
        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_eclipse_extension, (Object)url.toExternalForm()), null));
    }

    private static boolean isBaseDirectory(File base) {
        File plugins = new File(base, PLUGINS);
        File features = new File(base, FEATURES);
        return plugins.isDirectory() || features.isDirectory();
    }

    public Map getProperties() {
        if (this.metadataRepository == null) {
            return super.getProperties();
        }
        return this.metadataRepository.getProperties();
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
    }
}

