/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.BundlePoolFilteredListener;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryWatcher;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.RepositoryListener;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.spi.p2.core.repository.AbstractRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ExtensionLocationArtifactRepository
extends AbstractRepository
implements IFileArtifactRepository {
    public static final String TYPE = "org.eclipse.equinox.p2.extensionlocation.artifactRepository";
    private static final String POOLED = ".pooled";
    private static final String EXTENSION_LOCATION = ".eclipseextension";
    private static final String SITE_XML = "site.xml";
    private static final String ECLIPSE = "eclipse";
    private static final String FEATURES = "features";
    private static final String PLUGINS = "plugins";
    private static final String FILE = "file";
    private final IFileArtifactRepository artifactRepository;

    public static URL getLocalRepositoryLocation(URL location) {
        BundleContext context = Activator.getContext();
        String stateDirName = Integer.toString(location.toExternalForm().hashCode());
        File bundleData = context.getDataFile(null);
        File stateDir = new File(bundleData, stateDirName);
        try {
            return stateDir.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ExtensionLocationArtifactRepository(URL location, IFileArtifactRepository repository, IProgressMonitor monitor) throws ProvisionException {
        super("Extension: " + location.toExternalForm(), null, null, location, null, null, null);
        this.artifactRepository = repository;
        File base = ExtensionLocationArtifactRepository.getBaseDirectory(location);
        File plugins = new File(base, PLUGINS);
        File features = new File(base, FEATURES);
        DirectoryWatcher watcher = new DirectoryWatcher(new File[]{plugins, features});
        Object listener = new RepositoryListener(Activator.getContext(), null, (IArtifactRepository)this.artifactRepository);
        if (location.getPath().endsWith(POOLED)) {
            listener = new BundlePoolFilteredListener((DirectoryChangeListener)listener);
        }
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
    }

    public static void validate(URL location, IProgressMonitor monitor) throws ProvisionException {
        File base = ExtensionLocationArtifactRepository.getBaseDirectory(location);
        if (new File(base, EXTENSION_LOCATION).exists()) {
            return;
        }
        if (new File(base, SITE_XML).exists()) {
            String message = NLS.bind((String)Messages.error_update_site, (Object)location.toExternalForm());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, message, null));
        }
    }

    public static File getBaseDirectory(URL url) throws ProvisionException {
        if (!FILE.equals(url.getProtocol())) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, Messages.not_file_protocol, null));
        }
        String path = url.getPath();
        File base = new File(path);
        if (path.endsWith(POOLED)) {
            base = base.getParentFile();
        }
        if (!base.isDirectory()) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_directory, (Object)url.toExternalForm()), null));
        }
        if (ExtensionLocationArtifactRepository.isBaseDirectory(base)) {
            return base;
        }
        File eclipseBase = new File(base, ECLIPSE);
        if (ExtensionLocationArtifactRepository.isBaseDirectory(eclipseBase)) {
            return eclipseBase;
        }
        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_eclipse_extension, (Object)url.toExternalForm()), null));
    }

    private static boolean isBaseDirectory(File base) {
        File plugins = new File(base, PLUGINS);
        File features = new File(base, FEATURES);
        return plugins.isDirectory() || features.isDirectory();
    }

    public void addDescriptor(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    public void addDescriptors(IArtifactDescriptor[] descriptors) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public void removeDescriptor(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    public void removeDescriptor(IArtifactKey key) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        return this.artifactRepository.contains(descriptor);
    }

    public boolean contains(IArtifactKey key) {
        return this.artifactRepository.contains(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.artifactRepository.getArtifact(descriptor, destination, monitor);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        return this.artifactRepository.getArtifactDescriptors(key);
    }

    public IArtifactKey[] getArtifactKeys() {
        return this.artifactRepository.getArtifactKeys();
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        return this.artifactRepository.getArtifacts(requests, monitor);
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        return this.artifactRepository.getOutputStream(descriptor);
    }

    public File getArtifactFile(IArtifactKey key) {
        return this.artifactRepository.getArtifactFile(key);
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        return this.artifactRepository.getArtifactFile(descriptor);
    }
}

