/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.IUProfilePropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.PropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProfileSynchronizer {
    private static final String RECONCILER_APPLICATION_ID = "org.eclipse.equinox.p2.reconciler.application";
    private static final String TIMESTAMPS_FILE_PREFIX = "timestamps";
    private static final String PROFILE_TIMESTAMP = "PROFILE";
    private static final String NO_TIMESTAMP = "-1";
    private static final String PROP_FROM_DROPINS = "org.eclipse.equinox.p2.reconciler.dropins";
    private static final String CACHE_EXTENSIONS = "org.eclipse.equinox.p2.cache.extensions";
    private static final String PIPE = "|";
    final IProfile profile;
    final Map repositoryMap;
    private Properties timestamps;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ProfileSynchronizer(IProfile profile, Collection repositories) {
        this.profile = profile;
        this.repositoryMap = new HashMap();
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            IMetadataRepository repository = (IMetadataRepository)it.next();
            this.repositoryMap.put(repository.getLocation().toExternalForm(), repository);
        }
    }

    public IStatus synchronize(IProgressMonitor monitor) {
        this.readTimestamps();
        if (this.isUpToDate()) {
            return Status.OK_STATUS;
        }
        IStatus status = this.synchronizeCacheExtensions();
        if (!status.isOK()) {
            return status;
        }
        ProvisioningContext context = this.getContext();
        ProfileChangeRequest request = this.createProfileChangeRequest(context);
        if (request == null) {
            return Status.OK_STATUS;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ProvisioningPlan plan = this.createProvisioningPlan(request, context, (IProgressMonitor)sub.newChild(50));
            status = plan.getStatus();
            if (status.getSeverity() == 4 || plan.getOperands().length == 0) {
                IStatus iStatus = status;
                return iStatus;
            }
            IStatus engineResult = this.executePlan(plan, context, (IProgressMonitor)sub.newChild(50));
            if (!engineResult.isOK()) {
                IStatus iStatus = engineResult;
                return iStatus;
            }
            this.writeTimestamps();
            this.applyConfiguration();
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            sub.done();
        }
    }

    private void writeTimestamps() {
        this.timestamps.clear();
        this.timestamps.put(PROFILE_TIMESTAMP, Long.toString(this.profile.getTimestamp()));
        Iterator it = this.repositoryMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IMetadataRepository repository = (IMetadataRepository)entry.getValue();
            Map props = repository.getProperties();
            String timestamp = null;
            if (props != null) {
                timestamp = (String)props.get("p2.timestamp");
            }
            if (timestamp == null) {
                timestamp = NO_TIMESTAMP;
            }
            this.timestamps.put(entry.getKey(), timestamp);
        }
        try {
            File file = Activator.getContext().getDataFile(TIMESTAMPS_FILE_PREFIX + this.profile.getProfileId().hashCode());
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                this.timestamps.save(os, "Timestamps for " + this.profile.getProfileId());
            }
            finally {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private boolean isUpToDate() {
        if (this.profile.query((Query)new InstallableUnitQuery("org.eclipse.equinox.p2.dropins"), new Collector(), null).size() > 0) {
            return false;
        }
        String lastKnownProfileTimeStamp = (String)this.timestamps.remove(PROFILE_TIMESTAMP);
        if (lastKnownProfileTimeStamp == null) {
            return false;
        }
        if (!lastKnownProfileTimeStamp.equals(Long.toString(this.profile.getTimestamp()))) {
            return false;
        }
        Iterator it = this.repositoryMap.entrySet().iterator();
        while (it.hasNext()) {
            String lastKnownTimestamp;
            Map.Entry entry = it.next();
            IMetadataRepository repository = (IMetadataRepository)entry.getValue();
            Map props = repository.getProperties();
            String currentTimestamp = null;
            if (props != null) {
                currentTimestamp = (String)props.get("p2.timestamp");
            }
            if (currentTimestamp == null) {
                currentTimestamp = NO_TIMESTAMP;
            }
            if ((lastKnownTimestamp = (String)this.timestamps.remove(entry.getKey())) == null) {
                return false;
            }
            if (lastKnownTimestamp.equals(currentTimestamp)) continue;
            return false;
        }
        return this.timestamps.size() == 0;
    }

    private void readTimestamps() {
        File file = Activator.getContext().getDataFile(TIMESTAMPS_FILE_PREFIX + this.profile.getProfileId().hashCode());
        this.timestamps = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                this.timestamps.load(is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private ProvisioningContext getContext() {
        ArrayList<URL> repoURLs = new ArrayList<URL>();
        Iterator iterator = this.repositoryMap.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                repoURLs.add(new URL((String)iterator.next()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return new ProvisioningContext(repoURLs.toArray(new URL[repoURLs.size()]));
    }

    private IStatus synchronizeCacheExtensions() {
        ArrayList<String> currentExtensions = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.repositoryMap.keySet().iterator();
        while (it.hasNext()) {
            String repositoryId = (String)it.next();
            try {
                IArtifactRepository repository = Activator.loadArtifactRepository(new URL(repositoryId), null);
                if (!(repository instanceof IFileArtifactRepository)) continue;
                currentExtensions.add(repositoryId);
                buffer.append(repositoryId);
                if (!it.hasNext()) continue;
                buffer.append(PIPE);
            }
            catch (ProvisionException provisionException) {
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        String currentExtensionsProperty = buffer.length() == 0 ? null : buffer.toString();
        ArrayList<String> previousExtensions = new ArrayList<String>();
        String previousExtensionsProperty = this.profile.getProperty(CACHE_EXTENSIONS);
        if (previousExtensionsProperty != null) {
            StringTokenizer tokenizer = new StringTokenizer(previousExtensionsProperty, PIPE);
            while (tokenizer.hasMoreTokens()) {
                previousExtensions.add(tokenizer.nextToken());
            }
        }
        if (previousExtensions.size() == currentExtensions.size() && previousExtensions.containsAll(currentExtensions)) {
            return Status.OK_STATUS;
        }
        PropertyOperand operand = new PropertyOperand(CACHE_EXTENSIONS, (Object)previousExtensionsProperty, (Object)currentExtensionsProperty);
        return this.executeOperands(new ProvisioningContext(new URL[0]), new Operand[]{operand}, null);
    }

    public ProfileChangeRequest createProfileChangeRequest(ProvisioningContext context) {
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        ArrayList<IInstallableUnit> toAdd = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> toRemove = new ArrayList<IInstallableUnit>();
        Collector collect = this.profile.query((Query)new InstallableUnitQuery("org.eclipse.equinox.p2.dropins"), new Collector(), null);
        toRemove.addAll(collect.toCollection());
        Collector allIUs = this.getAllIUsFromRepos();
        Iterator iter = allIUs.iterator();
        while (iter.hasNext()) {
            final IInstallableUnit iu = (IInstallableUnit)iter.next();
            Query query = new Query(){

                public boolean isMatch(Object candidate) {
                    return iu.equals(candidate);
                }
            };
            Collector collector = this.profile.query(query, new Collector(), null);
            if (collector.size() != 0) continue;
            if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.type.group")).booleanValue()) {
                request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", (Object)Boolean.TRUE.toString());
            }
            request.setInstallableUnitProfileProperty(iu, PROP_FROM_DROPINS, (Object)Boolean.TRUE.toString());
            request.setInstallableUnitInclusionRules(iu, PlannerHelper.createOptionalInclusionRule((IInstallableUnit)iu));
            toAdd.add(iu);
        }
        Collector profileIUs = this.profile.query((Query)new IUProfilePropertyQuery(this.profile, PROP_FROM_DROPINS, Boolean.toString(true)), new Collector(), null);
        Collection all = allIUs.toCollection();
        Iterator iter2 = profileIUs.iterator();
        while (iter2.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iter2.next();
            if (all.contains(iu)) {
                toAdd.remove(iu);
                continue;
            }
            toRemove.add(iu);
        }
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            return null;
        }
        context.setExtraIUs(toAdd);
        request.addInstallableUnits(toAdd.toArray(new IInstallableUnit[toAdd.size()]));
        request.removeInstallableUnits(toRemove.toArray(new IInstallableUnit[toRemove.size()]));
        return request;
    }

    private Collector getAllIUsFromRepos() {
        Collector allRepos = new Collector();
        Iterator it = this.repositoryMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IMetadataRepository repository = (IMetadataRepository)entry.getValue();
            repository.query((Query)InstallableUnitQuery.ANY, allRepos, null).iterator();
        }
        return allRepos;
    }

    private ProvisioningPlan createProvisioningPlan(ProfileChangeRequest request, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IPlanner planner = (IPlanner)context.getService(reference);
        try {
            ProvisioningPlan provisioningPlan = planner.getProvisioningPlan(request, provisioningContext, monitor);
            return provisioningPlan;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private IStatus executePlan(ProvisioningPlan plan, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        Operand[] operands = plan.getOperands();
        return this.executeOperands(provisioningContext, operands, monitor);
    }

    private IStatus executeOperands(ProvisioningContext provisioningContext, Operand[] operands, IProgressMonitor monitor) {
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IEngine engine = (IEngine)context.getService(reference);
        try {
            IStatus engineResult;
            DefaultPhaseSet phaseSet = new DefaultPhaseSet();
            IStatus iStatus = engineResult = engine.perform(this.profile, (PhaseSet)phaseSet, operands, provisioningContext, monitor);
            return iStatus;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private void applyConfiguration() {
        if (this.isReconciliationApplicationRunning()) {
            return;
        }
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.configurator.Configurator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        Configurator configurator = (Configurator)context.getService(reference);
        try {
            try {
                configurator.applyConfiguration();
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, PROP_FROM_DROPINS, "Unexpected failure applying configuration", (Throwable)e));
                context.ungetService(reference);
            }
        }
        finally {
            context.ungetService(reference);
        }
    }

    private boolean isReconciliationApplicationRunning() {
        EnvironmentInfo info;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        String[] args = info.getCommandLineArgs();
        if (args == null) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && RECONCILER_APPLICATION_ID.equals(args[i].trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public class ListCollector
    extends Collector {
        public List getList() {
            return super.getList();
        }
    }
}

