/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Messages;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.ConfigurationParser;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.osgi.util.NLS;

public class PlatformXmlListener
extends DirectoryChangeListener {
    private static final String PLATFORM_XML = "platform.xml";
    private boolean changed = false;
    private File root;
    private long lastModified = -1L;
    private Set configRepositories;

    private String toString(String[] list) {
        if (list == null || list.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            buffer.append(list[i]);
            if (i + 1 < list.length) {
                buffer.append(',');
            }
            ++i;
        }
        return buffer.toString();
    }

    public PlatformXmlListener(File file) {
        if (!PLATFORM_XML.equals(file.getName())) {
            throw new IllegalArgumentException();
        }
        this.root = file;
    }

    public boolean added(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public boolean changed(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public Long getSeenFile(File file) {
        return new Long(0L);
    }

    public boolean isInterested(File file) {
        return file.getName().equals(PLATFORM_XML) && this.lastModified != file.lastModified();
    }

    public boolean removed(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public void startPoll() {
        this.changed = false;
    }

    public void stopPoll() {
        if (this.changed) {
            this.lastModified = this.root.lastModified();
            try {
                Configuration configuration = ConfigurationParser.parse((File)this.root, (URL)Activator.getOSGiInstallArea());
                this.synchronizeConfiguration(configuration);
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", Messages.errorProcessingConfg, (Throwable)e));
            }
        }
        this.changed = false;
    }

    public Collection getMetadataRepositories() {
        return this.configRepositories;
    }

    private IMetadataRepository getMatchingRepo(Collection repositoryList, String urlString) {
        if (repositoryList == null) {
            return null;
        }
        IPath urlPath = new Path(urlString).makeAbsolute();
        Iterator iter = repositoryList.iterator();
        while (iter.hasNext()) {
            IMetadataRepository repo = (IMetadataRepository)iter.next();
            Path repoPath = new Path(repo.getLocation().toExternalForm());
            if (!repoPath.makeAbsolute().equals((Object)urlPath)) continue;
            return repo;
        }
        return null;
    }

    protected void synchronizeConfiguration(Configuration config) {
        List sites = config.getSites();
        LinkedHashSet<IMetadataRepository> newRepos = new LinkedHashSet<IMetadataRepository>();
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            IMetadataRepository match;
            Site site = (Site)iter.next();
            String siteURL = site.getUrl();
            if (siteURL.startsWith("file:") && siteURL.endsWith("/eclipse/")) {
                siteURL = siteURL.substring(0, siteURL.length() - 8);
            }
            if ((match = this.getMatchingRepo(this.configRepositories, siteURL)) == null) {
                try {
                    URL location = new URL(siteURL);
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("org.eclipse.update.site.policy", site.getPolicy());
                    properties.put("org.eclipse.update.site.list", this.toString(site.getList()));
                    properties.put("p2.system", Boolean.TRUE.toString());
                    IMetadataRepository metadataRepository = null;
                    try {
                        metadataRepository = Activator.createExtensionLocationMetadataRepository(location, "extension location metadata repository: " + location.toExternalForm(), properties);
                    }
                    catch (ProvisionException provisionException) {
                        metadataRepository = Activator.loadMetadataRepository(location, null);
                    }
                    newRepos.add(metadataRepository);
                    try {
                        Activator.createExtensionLocationArtifactRepository(location, "extension location artifact repository: " + location.toExternalForm(), properties);
                    }
                    catch (ProvisionException provisionException) {
                        Activator.loadArtifactRepository(location, null);
                    }
                }
                catch (MalformedURLException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", NLS.bind((String)Messages.errorLoadingRepository, (Object)siteURL), (Throwable)e));
                }
                catch (ProvisionException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", NLS.bind((String)Messages.errorLoadingRepository, (Object)siteURL), (Throwable)e));
                }
                continue;
            }
            newRepos.add(match);
        }
        this.configRepositories = newRepos;
    }
}

