/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepository;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.repository.IRepository;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.RepositoryListener;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DropinsRepositoryListener
extends RepositoryListener {
    private static final String JAR = ".jar";
    private static final String LINK = ".link";
    private static final String ZIP = ".zip";
    private static final String LINKS_PATH = "path";
    private static final String DROPIN_ARTIFACT_REPOSITORIES = "dropin.artifactRepositories";
    private static final String DROPIN_METADATA_REPOSITORIES = "dropin.metadataRepositories";
    private static final String PIPE = "|";
    private BundleContext context;
    private List metadataRepositories = new ArrayList();
    private List artifactRepositories = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DropinsRepositoryListener(BundleContext context, String repositoryName) {
        super(context, repositoryName, null, true);
        this.context = context;
    }

    public boolean isInterested(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName();
        return name.endsWith(JAR) || name.endsWith(ZIP) || name.endsWith(LINK);
    }

    public boolean added(File file) {
        if (super.added(file)) {
            return true;
        }
        URL repositoryURL = this.createRepositoryURL(file);
        if (repositoryURL != null) {
            this.getMetadataRepository(repositoryURL);
            this.getArtifactRepository(repositoryURL);
        }
        return true;
    }

    public boolean changed(File file) {
        if (super.changed(file)) {
            return true;
        }
        URL repositoryURL = this.createRepositoryURL(file);
        if (repositoryURL != null) {
            this.getMetadataRepository(repositoryURL);
            this.getArtifactRepository(repositoryURL);
        }
        return true;
    }

    private String getLinkPath(File file) {
        Properties links = new Properties();
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                links.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (IOException iOException) {}
        String path = links.getProperty(LINKS_PATH);
        if (path == null) {
            return null;
        }
        path = path.startsWith("r ") ? path.substring(2).trim() : (path.startsWith("rw ") ? path.substring(3).trim() : path.trim());
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL createRepositoryURL(File file) {
        try {
            if (file.getName().endsWith(LINK)) {
                File root;
                File linkFile = file;
                String path = this.getLinkPath(linkFile);
                if (path == null) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Unable to determine link location from file: " + file.getAbsolutePath()));
                    return null;
                }
                file = new File(path);
                if (!file.isAbsolute() && (root = Activator.getEclipseHome()) != null) {
                    file = new File(root, path);
                }
            }
            File canonicalFile = file.getCanonicalFile();
            URL repositoryURL = canonicalFile.toURL();
            if (canonicalFile.getName().endsWith(ZIP)) return new URL("jar:" + repositoryURL.toString() + "!/");
            if (!canonicalFile.getName().endsWith(JAR)) return repositoryURL;
            return new URL("jar:" + repositoryURL.toString() + "!/");
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while building repository location from file: " + file.getAbsolutePath(), (Throwable)e));
            return null;
        }
    }

    public void getMetadataRepository(URL repoURL) {
        try {
            IMetadataRepository repository = null;
            try {
                ExtensionLocationMetadataRepository.validate((URL)repoURL, null);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("p2.system", Boolean.TRUE.toString());
                repository = Activator.createExtensionLocationMetadataRepository(repoURL, "dropins metadata repo: " + repoURL.toExternalForm(), properties);
            }
            catch (ProvisionException provisionException) {
                repository = Activator.loadMetadataRepository(repoURL, null);
            }
            this.metadataRepositories.add(repository);
        }
        catch (ProvisionException ex) {
            LogHelper.log((ProvisionException)ex);
        }
    }

    public void getArtifactRepository(URL repoURL) {
        try {
            IArtifactRepository repository = null;
            try {
                ExtensionLocationArtifactRepository.validate((URL)repoURL, null);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("p2.system", Boolean.TRUE.toString());
                repository = Activator.createExtensionLocationArtifactRepository(repoURL, "dropins artifact repo: " + repoURL.toExternalForm(), properties);
            }
            catch (ProvisionException provisionException) {
                repository = Activator.loadArtifactRepository(repoURL, null);
            }
            this.artifactRepositories.add(repository);
        }
        catch (ProvisionException ex) {
            LogHelper.log((ProvisionException)ex);
        }
    }

    public void stopPoll() {
        this.synchronizeDropinMetadataRepositories();
        this.synchronizeDropinArtifactRepositories();
        super.stopPoll();
    }

    private void synchronizeDropinMetadataRepositories() {
        ArrayList<String> currentRepositories = new ArrayList<String>();
        Iterator it = this.metadataRepositories.iterator();
        while (it.hasNext()) {
            IMetadataRepository repository = (IMetadataRepository)it.next();
            String urlString = repository.getLocation().toExternalForm();
            currentRepositories.add(urlString);
        }
        List previousRepositories = this.getListRepositoryProperty((IRepository)this.getMetadataRepository(), DROPIN_METADATA_REPOSITORIES);
        Iterator iterator = previousRepositories.iterator();
        while (iterator.hasNext()) {
            String repository = (String)iterator.next();
            if (currentRepositories.contains(repository)) continue;
            this.removeMetadataRepository(repository);
        }
        this.setListRepositoryProperty((IRepository)this.getMetadataRepository(), DROPIN_METADATA_REPOSITORIES, currentRepositories);
    }

    private void removeMetadataRepository(String urlString) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = this.context.getServiceReference(clazz.getName());
        IMetadataRepositoryManager manager = null;
        if (reference != null) {
            manager = (IMetadataRepositoryManager)this.context.getService(reference);
        }
        if (manager == null) {
            throw new IllegalStateException(Messages.metadata_repo_manager_not_registered);
        }
        try {
            try {
                manager.removeRepository(new URL(urlString));
            }
            catch (MalformedURLException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while creating URL from: " + urlString, (Throwable)e));
                this.context.ungetService(reference);
            }
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    private void synchronizeDropinArtifactRepositories() {
        ArrayList<String> currentRepositories = new ArrayList<String>();
        Iterator it = this.artifactRepositories.iterator();
        while (it.hasNext()) {
            IArtifactRepository repository = (IArtifactRepository)it.next();
            String urlString = repository.getLocation().toExternalForm();
            currentRepositories.add(urlString);
        }
        List previousRepositories = this.getListRepositoryProperty((IRepository)this.getArtifactRepository(), DROPIN_ARTIFACT_REPOSITORIES);
        Iterator iterator = previousRepositories.iterator();
        while (iterator.hasNext()) {
            String repository = (String)iterator.next();
            if (currentRepositories.contains(repository)) continue;
            this.removeArtifactRepository(repository);
        }
        this.setListRepositoryProperty((IRepository)this.getArtifactRepository(), DROPIN_ARTIFACT_REPOSITORIES, currentRepositories);
    }

    public void removeArtifactRepository(String urlString) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = this.context.getServiceReference(clazz.getName());
        IArtifactRepositoryManager manager = null;
        if (reference != null) {
            manager = (IArtifactRepositoryManager)this.context.getService(reference);
        }
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_manager_not_registered);
        }
        try {
            try {
                manager.removeRepository(new URL(urlString));
            }
            catch (MalformedURLException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while creating URL from: " + urlString, (Throwable)e));
                this.context.ungetService(reference);
            }
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    private List getListRepositoryProperty(IRepository repository, String key) {
        ArrayList<String> listProperty = new ArrayList<String>();
        String dropinRepositories = (String)repository.getProperties().get(key);
        if (dropinRepositories != null) {
            StringTokenizer tokenizer = new StringTokenizer(dropinRepositories, PIPE);
            while (tokenizer.hasMoreTokens()) {
                listProperty.add(tokenizer.nextToken());
            }
        }
        return listProperty;
    }

    private void setListRepositoryProperty(IRepository repository, String key, List listProperty) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = listProperty.iterator();
        while (it.hasNext()) {
            String repositoryString = (String)it.next();
            buffer.append(repositoryString);
            if (!it.hasNext()) continue;
            buffer.append(PIPE);
        }
        String value = buffer.length() == 0 ? null : buffer.toString();
        repository.setProperty(key, value);
    }

    public Collection getMetadataRepositories() {
        ArrayList<IMetadataRepository> result = new ArrayList<IMetadataRepository>(this.metadataRepositories);
        result.add(this.getMetadataRepository());
        return result;
    }
}

