/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.reconciler.dropins.DropinsRepositoryListener;
import org.eclipse.equinox.internal.p2.reconciler.dropins.PlatformXmlListener;
import org.eclipse.equinox.internal.p2.reconciler.dropins.ProfileSynchronizer;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryWatcher;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
implements BundleActivator {
    public static final String ID = "org.eclipse.equinox.p2.reconciler.dropins";
    private static final String DROPINS_DIRECTORY = "org.eclipse.equinox.p2.reconciler.dropins.directory";
    private static final String DROPINS = "dropins";
    private static final String LINKS = "links";
    private static PackageAdmin packageAdmin;
    private static BundleContext bundleContext;
    private ServiceReference packageAdminRef;
    private List watchers = new ArrayList();
    private static Collection dropinRepositories;
    private static Collection configurationRepositories;
    private static IMetadataRepository[] linksRepositories;
    private static IMetadataRepository eclipseProductRepository;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static IMetadataRepository createExtensionLocationMetadataRepository(URL location, String name, Map properties) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("MetadataRepositoryManager not registered.");
        }
        ExtensionLocationMetadataRepositoryFactory factory = new ExtensionLocationMetadataRepositoryFactory();
        IMetadataRepository repository = factory.create(location, name, "org.eclipse.equinox.p2.extensionlocation.metadataRepository", properties);
        manager.addRepository(location);
        return repository;
    }

    public static IMetadataRepository loadMetadataRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("MetadataRepositoryManager not registered.");
        }
        return manager.loadRepository(location, monitor);
    }

    public static IArtifactRepository createExtensionLocationArtifactRepository(URL location, String name, Map properties) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("ArtifactRepositoryManager not registered.");
        }
        ExtensionLocationArtifactRepositoryFactory factory = new ExtensionLocationArtifactRepositoryFactory();
        IArtifactRepository repository = factory.create(location, name, "org.eclipse.equinox.p2.extensionlocation.artifactRepository", properties);
        manager.addRepository(location);
        return repository;
    }

    public static IArtifactRepository loadArtifactRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("ArtifactRepositoryManager not registered.");
        }
        return manager.loadRepository(location, monitor);
    }

    public void start(BundleContext context) throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminRef = context.getServiceReference(clazz.getName());
        Activator.setPackageAdmin((PackageAdmin)context.getService(this.packageAdminRef));
        bundleContext = context;
        if (!this.startEarly("org.eclipse.equinox.p2.exemplarysetup")) {
            return;
        }
        if (!this.startEarly("org.eclipse.equinox.simpleconfigurator.manipulator")) {
            return;
        }
        if (!this.startEarly("org.eclipse.equinox.frameworkadmin.equinox")) {
            return;
        }
        IProfile profile = Activator.getCurrentProfile(context);
        if (profile == null) {
            return;
        }
        this.removeOldRepos();
        this.watchDropins(profile);
        this.watchConfiguration();
        Activator.synchronize(null);
        dropinRepositories = null;
        configurationRepositories = null;
        linksRepositories = null;
        eclipseProductRepository = null;
    }

    private void removeOldRepos() {
        IMetadataRepositoryManager metadataManager;
        IArtifactRepositoryManager artifactManager;
        URL osgiInstallArea = Activator.getOSGiInstallArea();
        if (osgiInstallArea == null) {
            return;
        }
        URL location = null;
        try {
            location = new URL(Activator.getOSGiInstallArea(), ".pooled");
        }
        catch (MalformedURLException e) {
            LogHelper.log((IStatus)new Status(4, ID, "Error occurred while removing old repositories.", (Throwable)e));
            return;
        }
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((artifactManager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("ArtifactRepositoryManager not registered.");
        }
        artifactManager.removeRepository(location);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((metadataManager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz2.getName())) == null) {
            throw new IllegalStateException("MetadataRepositoryManager not registered.");
        }
        metadataManager.removeRepository(location);
    }

    private boolean startEarly(String bundleName) throws BundleException {
        Bundle bundle = Activator.getBundle(bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    public static synchronized void synchronize(IProgressMonitor monitor) {
        ProfileSynchronizer synchronizer;
        IStatus result;
        IProfile profile = Activator.getCurrentProfile(bundleContext);
        if (profile == null) {
            return;
        }
        HashSet<IMetadataRepository> repositories = new HashSet<IMetadataRepository>();
        if (dropinRepositories != null) {
            repositories.addAll(dropinRepositories);
        }
        if (configurationRepositories != null) {
            repositories.addAll(configurationRepositories);
        }
        if (linksRepositories != null) {
            repositories.addAll(Arrays.asList(linksRepositories));
        }
        if (eclipseProductRepository != null) {
            repositories.add(eclipseProductRepository);
        }
        if (!(result = (synchronizer = new ProfileSynchronizer(profile, repositories)).synchronize(monitor)).isOK()) {
            LogHelper.log((IStatus)result);
        }
    }

    private void watchConfiguration() {
        File configFile = Activator.getConfigurationLocation();
        if (configFile == null) {
            LogHelper.log((IStatus)new Status(4, ID, "Unable to determine configuration location."));
            return;
        }
        configFile = new File(configFile, "org.eclipse.update/platform.xml");
        DirectoryWatcher watcher = new DirectoryWatcher(configFile.getParentFile());
        PlatformXmlListener listener = new PlatformXmlListener(configFile);
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
        configurationRepositories = listener.getMetadataRepositories();
    }

    private void watchDropins(IProfile profile) {
        File linksDirectory;
        ArrayList<File> directories = new ArrayList<File>();
        File dropinsDirectory = Activator.getDropinsDirectory();
        if (dropinsDirectory != null) {
            directories.add(dropinsDirectory);
        }
        if ((linksDirectory = Activator.getLinksDirectory()) != null) {
            directories.add(linksDirectory);
        }
        if (directories.isEmpty()) {
            return;
        }
        DropinsRepositoryListener listener = new DropinsRepositoryListener(Activator.getContext(), dropinsDirectory.getAbsolutePath());
        DirectoryWatcher watcher = new DirectoryWatcher(directories.toArray(new File[directories.size()]));
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
        dropinRepositories = listener.getMetadataRepositories();
    }

    public void stop(BundleContext context) throws Exception {
        Iterator iter = this.watchers.iterator();
        while (iter.hasNext()) {
            DirectoryWatcher watcher = (DirectoryWatcher)iter.next();
            watcher.stop();
        }
        bundleContext = null;
        Activator.setPackageAdmin(null);
        context.ungetService(this.packageAdminRef);
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    public static File getConfigurationLocation() {
        Location configurationLocation;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((configurationLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.CONFIGURATION_FILTER)) == null || !configurationLocation.isSet()) {
            return null;
        }
        URL url = configurationLocation.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    public static URL getOSGiInstallArea() {
        Location location;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((location = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.INSTALL_FILTER)) == null) {
            return null;
        }
        if (!location.isSet()) {
            return null;
        }
        return location.getURL();
    }

    public static File getEclipseHome() {
        Location eclipseHome;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((eclipseHome = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.ECLIPSE_HOME_FILTER)) == null || !eclipseHome.isSet()) {
            return null;
        }
        URL url = eclipseHome.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    private static File getLinksDirectory() {
        File root = Activator.getEclipseHome();
        return root == null ? null : new File(root, LINKS);
    }

    private static File getDropinsDirectory() {
        String watchedDirectoryProperty = bundleContext.getProperty(DROPINS_DIRECTORY);
        if (watchedDirectoryProperty != null) {
            return new File(watchedDirectoryProperty);
        }
        File root = Activator.getEclipseHome();
        return root == null ? null : new File(root, DROPINS);
    }

    public static IProfile getCurrentProfile(BundleContext context) {
        ServiceReference reference;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = context.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)context.getService(reference);
        try {
            IProfile iProfile = profileRegistry.getProfile("_SELF_");
            return iProfile;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private static synchronized void setPackageAdmin(PackageAdmin service) {
        packageAdmin = service;
    }

    static synchronized Bundle getBundle(String symbolicName) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }
}

