/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.registry.ConfigurationElementAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionPointAdapter;
import org.eclipse.pde.internal.runtime.registry.IBundleFolder;
import org.eclipse.pde.internal.runtime.registry.IBundleLibrary;
import org.eclipse.pde.internal.runtime.registry.IBundlePrerequisite;
import org.eclipse.pde.internal.runtime.registry.PluginAdapter;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.ServiceReferenceAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RegistryBrowserContentProvider
implements ITreeContentProvider {
    private Hashtable fExtensionPointMap = new Hashtable();
    public boolean isInExtensionSet;

    protected static PluginObjectAdapter createAdapter(Object object, int id) {
        if (id == 1) {
            return new ExtensionAdapter(object);
        }
        if (id == 2) {
            return new ExtensionPointAdapter(object);
        }
        return new PluginObjectAdapter(object);
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object[] getChildren(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ExtensionAdapter) {
            return ((ExtensionAdapter)((Object)element)).getChildren();
        }
        this.isInExtensionSet = false;
        if (element instanceof ExtensionPointAdapter) {
            return ((ExtensionPointAdapter)((Object)element)).getChildren();
        }
        if (element instanceof ConfigurationElementAdapter) {
            return ((ConfigurationElementAdapter)((Object)element)).getChildren();
        }
        if (element instanceof PluginAdapter) {
            PluginAdapter bundle = (PluginAdapter)((Object)element);
            Object[] folders = bundle.getChildren();
            ArrayList<Object> folderList = new ArrayList<Object>();
            int i = 0;
            while (i < folders.length) {
                if (folders[i] != null && ((IBundleFolder)folders[i]).getChildren() != null || ((IBundleFolder)folders[i]).getFolderId() == 0) {
                    folderList.add(folders[i]);
                }
                ++i;
            }
            folders = folderList.toArray(new Object[folderList.size()]);
            return folders;
        }
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element instanceof IBundleFolder) {
            IBundleFolder folder = (IBundleFolder)element;
            this.isInExtensionSet = folder.getFolderId() == 1;
            return ((IBundleFolder)element).getChildren();
        }
        if (element instanceof IConfigurationElement) {
            return ((IConfigurationElement)element).getChildren();
        }
        if (element instanceof Object[]) {
            return (Object[])element;
        }
        if (element instanceof IExtensionPoint) {
            IExtension[] array;
            IExtensionPoint extensionPoint = (IExtensionPoint)element;
            String id = extensionPoint.getUniqueIdentifier();
            Object[] children = (Object[])this.fExtensionPointMap.get(id);
            if (children == null && (array = extensionPoint.getExtensions()) != null && array.length > 0) {
                children = new Object[array.length];
                int i = 0;
                while (i < array.length) {
                    children[i] = RegistryBrowserContentProvider.createAdapter(array[i], 1);
                    ++i;
                }
                this.fExtensionPointMap.put(id, children);
            }
            return children;
        }
        return null;
    }

    protected static Object[] getFolderChildren(Bundle bundle, int id) {
        Object[] array = null;
        String bundleId = bundle.getSymbolicName();
        switch (id) {
            case 1: {
                array = Platform.getExtensionRegistry().getExtensions(bundleId);
                break;
            }
            case 2: {
                array = Platform.getExtensionRegistry().getExtensionPoints(bundleId);
                break;
            }
            case 3: {
                array = RegistryBrowserContentProvider.getManifestHeaderArray(bundle, "Require-Bundle");
                break;
            }
            case 4: {
                array = RegistryBrowserContentProvider.getManifestHeaderArray(bundle, "Bundle-ClassPath");
                break;
            }
            case 5: {
                return RegistryBrowserContentProvider.getServices(bundle, 5);
            }
            case 6: {
                return RegistryBrowserContentProvider.getServices(bundle, 6);
            }
        }
        Object[] result = null;
        if (array != null && array.length > 0) {
            result = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = RegistryBrowserContentProvider.createAdapter(array[i], id);
                ++i;
            }
        }
        return result;
    }

    protected static Object[] getServices(Bundle bundle, int type) {
        HashSet<ServiceReferenceAdapter> result = new HashSet<ServiceReferenceAdapter>();
        try {
            ServiceReference[] references = PDERuntimePlugin.getDefault().getBundleContext().getAllServiceReferences(null, null);
            int i = 0;
            while (i < references.length) {
                ServiceReference ref = references[i];
                if (type == 5 && bundle.equals(ref.getBundle())) {
                    result.add(new ServiceReferenceAdapter(ref));
                }
                Bundle[] usingBundles = ref.getUsingBundles();
                if (type == 6 && usingBundles != null && Arrays.asList(usingBundles).contains(bundle)) {
                    result.add(new ServiceReferenceAdapter(ref));
                }
                ++i;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new ServiceReferenceAdapter[result.size()]);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private static Object[] getManifestHeaderArray(Bundle bundle, String headerKey) {
        ManifestElement[] elements;
        block7: {
            String libraries = (String)bundle.getHeaders().get(headerKey);
            elements = ManifestElement.parseHeader((String)headerKey, (String)libraries);
            if (elements != null) break block7;
            return null;
        }
        try {
            if (headerKey.equals("Bundle-ClassPath")) {
                Object[] array = new IBundleLibrary[elements.length];
                int i = 0;
                while (i < elements.length) {
                    array[i] = new BundleLibrary(elements[i]);
                    ++i;
                }
                return array;
            }
            if (headerKey.equals("Require-Bundle")) {
                Object[] array = new IBundlePrerequisite[elements.length];
                int i = 0;
                while (i < elements.length) {
                    array[i] = new BundlePrerequisite(elements[i]);
                    ++i;
                }
                return array;
            }
        }
        catch (BundleException bundleException) {}
        return null;
    }

    static class BundleFolder
    implements IBundleFolder {
        private int id;
        private Bundle bundle;
        private Object[] children;

        public BundleFolder(Bundle pd, int id) {
            this.bundle = pd;
            this.id = id;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                this.children = RegistryBrowserContentProvider.getFolderChildren(this.bundle, this.id);
            }
            return this.children;
        }

        public void refresh() {
            this.children = null;
        }

        public int getFolderId() {
            return this.id;
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }

    static class BundleLibrary
    implements IBundleLibrary {
        private ManifestElement underlyingElement;

        public BundleLibrary(ManifestElement element) {
            this.underlyingElement = element;
        }

        public String getLibrary() {
            return this.underlyingElement.getValue();
        }
    }

    static class BundlePrerequisite
    implements IBundlePrerequisite {
        private ManifestElement underlyingElement;

        public BundlePrerequisite(ManifestElement element) {
            this.underlyingElement = element;
        }

        public ManifestElement getPrerequisite() {
            return this.underlyingElement;
        }

        public boolean isExported() {
            String visibility = this.underlyingElement.getDirective("visibility");
            return "reexport".equals(visibility);
        }

        public String getLabel() {
            String version = this.underlyingElement.getAttribute("bundle-version");
            String value = this.underlyingElement.getValue();
            if (version == null) {
                return value;
            }
            if (Character.isDigit(version.charAt(0))) {
                version = String.valueOf('(') + version + ')';
            }
            return String.valueOf(value) + ' ' + version;
        }
    }
}

