/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.orders;

import java.math.BigInteger;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarOrderHeapObjective
extends VarOrderHeap<ILits> {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction obj;

    public VarOrderHeapObjective() {
        this((IPhaseSelectionStrategy)new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public VarOrderHeapObjective(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        super(iPhaseSelectionStrategy);
    }

    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.obj = objectiveFunction;
    }

    public void init() {
        super.init();
        if (this.obj != null) {
            IVecInt iVecInt = this.obj.getVars();
            IVec<BigInteger> iVec = this.obj.getCoeffs();
            for (int i = 0; i < iVecInt.size(); ++i) {
                int n = this.lits.getFromPool(iVecInt.get(i));
                BigInteger bigInteger = (BigInteger)iVec.get(i);
                if (bigInteger.signum() < 0) {
                    n = LiteralsUtils.neg((int)n);
                }
                int n2 = LiteralsUtils.var((int)n);
                this.activity[n2] = bigInteger.abs().doubleValue();
                if (this.heap.inHeap(n2)) {
                    this.heap.increase(n2);
                } else {
                    this.heap.insert(n2);
                }
                this.phaseStrategy.init(n2, LiteralsUtils.neg((int)n));
            }
        }
    }

    public String toString() {
        return new StringBuffer().append(super.toString()).append(" taking into account the objective function").toString();
    }
}

