/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactoryPB;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.IInternalPBConstraintCreator;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPBClauseCardConstrDataStructurePB
extends AbstractPBDataStructureFactoryPB
implements IInternalPBConstraintCreator {
    private static final BigInteger MAX_INT_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$constraints$AbstractPBClauseCardConstrDataStructurePB;

    @Override
    protected PBConstr constraintFactory(IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        return this.constraintFactory(iVecInt, WatchPb.toVecBigInt(iVecInt2), bl, WatchPb.toBigInt(n));
    }

    @Override
    protected PBConstr constraintFactory(IVecInt iVecInt, IVecInt iVecInt2, int n) {
        return this.constraintFactory(iVecInt, WatchPb.toVecBigInt(iVecInt2), WatchPb.toBigInt(n));
    }

    @Override
    protected PBConstr constraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        IDataStructurePB iDataStructurePB = WatchPb.niceParameters(iVecInt, iVec, bl, bigInteger, this.getVocabulary());
        if (iDataStructurePB == null) {
            return null;
        }
        int n = iDataStructurePB.size();
        int[] nArray = new int[n];
        Object[] objectArray = new BigInteger[n];
        iDataStructurePB.buildConstraintFromMapPb(nArray, (BigInteger[])objectArray);
        if (iDataStructurePB.getDegree().equals(BigInteger.ONE)) {
            IVecInt iVecInt2 = WLClause.sanityCheck((IVecInt)new VecInt(nArray), (ILits)this.getVocabulary(), (UnitPropagationListener)this.solver);
            if (iVecInt2 == null) {
                return null;
            }
            return this.constructClause(iVecInt2);
        }
        if (AbstractPBClauseCardConstrDataStructurePB.coefficientsEqualToOne((IVec<BigInteger>)new Vec(objectArray))) {
            if (!$assertionsDisabled && iDataStructurePB.getDegree().compareTo(MAX_INT_VALUE) >= 0) {
                throw new AssertionError();
            }
            return this.constructCard((IVecInt)new VecInt(nArray), iDataStructurePB.getDegree().intValue());
        }
        return this.constructPB(nArray, (BigInteger[])objectArray, iDataStructurePB.getDegree());
    }

    @Override
    protected PBConstr constraintFactory(IDataStructurePB iDataStructurePB) {
        if (iDataStructurePB.getDegree().equals(BigInteger.ONE)) {
            return this.constructLearntClause(iDataStructurePB);
        }
        if (iDataStructurePB.isCardinality()) {
            return this.constructLearntCard(iDataStructurePB);
        }
        return this.constructLearntPB(iDataStructurePB);
    }

    @Override
    protected PBConstr constraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ONE)) {
            return this.constructLearntClause(iVecInt);
        }
        if (AbstractPBClauseCardConstrDataStructurePB.coefficientsEqualToOne(iVec)) {
            return this.constructLearntCard(iVecInt, bigInteger.intValue());
        }
        return this.constructLearntPB(iVecInt, iVec, bigInteger);
    }

    private static boolean coefficientsEqualToOne(IVec<BigInteger> iVec) {
        for (int i = 0; i < iVec.size(); ++i) {
            if (((BigInteger)iVec.get(i)).equals(BigInteger.ONE)) continue;
            return false;
        }
        return true;
    }

    protected abstract PBConstr constructClause(IVecInt var1);

    protected abstract PBConstr constructCard(IVecInt var1, int var2) throws ContradictionException;

    protected abstract PBConstr constructPB(IDataStructurePB var1) throws ContradictionException;

    protected abstract PBConstr constructPB(int[] var1, BigInteger[] var2, BigInteger var3) throws ContradictionException;

    protected abstract PBConstr constructLearntClause(IVecInt var1);

    protected abstract PBConstr constructLearntCard(IVecInt var1, int var2);

    protected abstract PBConstr constructLearntPB(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);

    protected abstract PBConstr constructLearntClause(IDataStructurePB var1);

    protected abstract PBConstr constructLearntCard(IDataStructurePB var1);

    protected abstract PBConstr constructLearntPB(IDataStructurePB var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$constraints$AbstractPBClauseCardConstrDataStructurePB == null ? (class$org$sat4j$pb$constraints$AbstractPBClauseCardConstrDataStructurePB = AbstractPBClauseCardConstrDataStructurePB.class$("org.sat4j.pb.constraints.AbstractPBClauseCardConstrDataStructurePB")) : class$org$sat4j$pb$constraints$AbstractPBClauseCardConstrDataStructurePB).desiredAssertionStatus();
        MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    }
}

