/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarOrder<L extends ILits>
implements Serializable,
IOrder<L> {
    private static final long serialVersionUID = 1L;
    private static final double VAR_RESCALE_FACTOR = 1.0E-100;
    private static final double VAR_RESCALE_BOUND = 1.0E100;
    protected double[] activity = new double[1];
    protected int lastVar = 1;
    protected int[] order = new int[1];
    private double varDecay = 1.0;
    private double varInc = 1.0;
    protected int[] varpos = new int[1];
    protected L lits;
    private long nullchoice = 0L;
    protected IPhaseSelectionStrategy phaseStrategy;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$minisat$orders$VarOrder;

    public VarOrder() {
        this(new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public VarOrder(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        this.phaseStrategy = iPhaseSelectionStrategy;
    }

    @Override
    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        this.phaseStrategy = iPhaseSelectionStrategy;
    }

    @Override
    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.phaseStrategy;
    }

    @Override
    public void setLits(L l) {
        this.lits = l;
    }

    @Override
    public void newVar() {
        this.newVar(1);
    }

    @Override
    public void newVar(int n) {
    }

    @Override
    public int select() {
        if (!$assertionsDisabled && this.lastVar <= 0) {
            throw new AssertionError();
        }
        for (int i = this.lastVar; i < this.order.length; ++i) {
            if (!$assertionsDisabled && i <= 0) {
                throw new AssertionError();
            }
            if (!this.lits.isUnassigned(this.order[i])) continue;
            this.lastVar = i;
            if (this.activity[i] < 1.0E-4) {
                ++this.nullchoice;
            }
            return this.order[i];
        }
        return -1;
    }

    @Override
    public void setVarDecay(double d) {
        this.varDecay = d;
    }

    @Override
    public void undo(int n) {
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= this.order.length) {
            throw new AssertionError();
        }
        int n2 = this.varpos[n];
        if (n2 < this.lastVar) {
            this.lastVar = n2;
        }
        if (!$assertionsDisabled && this.lastVar <= 0) {
            throw new AssertionError();
        }
    }

    @Override
    public void updateVar(int n) {
        int n2;
        if (!$assertionsDisabled && n <= 1) {
            throw new AssertionError();
        }
        int n3 = LiteralsUtils.var(n);
        this.updateActivity(n3);
        for (n2 = this.varpos[n3]; n2 > 1 && this.activity[LiteralsUtils.var(this.order[n2 - 1])] < this.activity[n3]; --n2) {
            if (!$assertionsDisabled && n2 <= 1) {
                throw new AssertionError();
            }
            int n4 = this.order[n2 - 1];
            if (!$assertionsDisabled && this.varpos[LiteralsUtils.var(n4)] != n2 - 1) {
                throw new AssertionError();
            }
            this.varpos[LiteralsUtils.var((int)n4)] = n2;
            this.order[n2] = n4;
        }
        if (!$assertionsDisabled && n2 < 1) {
            throw new AssertionError();
        }
        this.varpos[n3] = n2;
        this.order[n2] = n;
        if (n2 < this.lastVar) {
            this.lastVar = n2;
        }
    }

    protected void updateActivity(int n) {
        int n2 = n;
        double d = this.activity[n2] = this.activity[n2] + this.varInc;
        if (d > 1.0E100) {
            this.varRescaleActivity();
        }
    }

    @Override
    public void varDecayActivity() {
        this.varInc *= this.varDecay;
    }

    private void varRescaleActivity() {
        int n = 1;
        while (n < this.activity.length) {
            int n2 = n++;
            this.activity[n2] = this.activity[n2] * 1.0E-100;
        }
        this.varInc *= 1.0E-100;
    }

    @Override
    public double varActivity(int n) {
        return this.activity[LiteralsUtils.var(n)];
    }

    public int numberOfInterestingVariables() {
        int n = 0;
        for (int i = 1; i < this.activity.length; ++i) {
            if (!(this.activity[i] > 1.0)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void init() {
        int n = this.lits.nVars() + 1;
        int n2 = this.lits.realnVars() + 1;
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        int[] nArray2 = new int[n2];
        nArray[0] = -1;
        dArray[0] = -1.0;
        nArray2[0] = -1;
        int n3 = 1;
        for (int i = 1; i < n; ++i) {
            if (!$assertionsDisabled && i <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && i > this.lits.nVars()) {
                throw new AssertionError((Object)new StringBuffer().append("").append(this.lits.nVars()).append("/").append(i).toString());
            }
            if (this.lits.belongsToPool(i)) {
                nArray2[n3] = LiteralsUtils.neg(this.lits.getFromPool(i));
                nArray[i] = n3++;
            }
            dArray[i] = 0.0;
        }
        this.varpos = nArray;
        this.activity = dArray;
        this.order = nArray2;
        this.lastVar = 1;
    }

    public String toString() {
        return "VSIDS like heuristics from MiniSAT using a sorted array";
    }

    public ILits getVocabulary() {
        return this.lits;
    }

    @Override
    public void printStat(PrintWriter printWriter, String string) {
        printWriter.println(new StringBuffer().append(string).append("non guided choices\t").append(this.nullchoice).toString());
    }

    @Override
    public void assignLiteral(int n) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$minisat$orders$VarOrder == null ? (class$org$sat4j$minisat$orders$VarOrder = VarOrder.class$("org.sat4j.minisat.orders.VarOrder")) : class$org$sat4j$minisat$orders$VarOrder).desiredAssertionStatus();
    }
}

