/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage.view;

import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.view.ISecurePreferencesSelection;
import org.eclipse.equinox.internal.security.ui.storage.view.NewNodeDialog;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;

public class NodesView {
    private static final String defaultPrefs = "default";
    protected ISecurePreferencesSelection parentView;
    protected TreeViewer nodeTreeViewer;
    protected ViewContentProvider contentProvider;
    protected Action addNodeAction;
    protected Action removeNodeAction;
    protected Action refreshNodesAction;
    static /* synthetic */ Class class$0;

    public NodesView(Tree nodeTree, final ISecurePreferencesSelection parentView) {
        this.parentView = parentView;
        this.nodeTreeViewer = new TreeViewer(nodeTree);
        this.contentProvider = new ViewContentProvider();
        this.nodeTreeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.nodeTreeViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.nodeTreeViewer.setInput((Object)defaultPrefs);
        this.nodeTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object selected = selection.getFirstElement();
                if (selected instanceof ISecurePreferences) {
                    parentView.setSelection((ISecurePreferences)selected);
                } else {
                    parentView.setSelection(null);
                }
            }
        });
        if (Activator.getDefault().debugStorageContents()) {
            this.makeActions();
            this.hookContextMenu();
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(SecUIMessages.nodesContextMenu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean canRemove = false;
                boolean canAdd = false;
                TreeSelection selection = (TreeSelection)NodesView.this.nodeTreeViewer.getSelection();
                Object selected = selection.getFirstElement();
                if (selected instanceof ISecurePreferences) {
                    ISecurePreferences node = (ISecurePreferences)selected;
                    boolean isRoot = node.parent() == null;
                    boolean isInternal = node.absolutePath().startsWith("/org.eclipse.equinox.secure.storage");
                    canRemove = !isRoot && !isInternal;
                    canAdd = !isInternal;
                }
                NodesView.this.removeNodeAction.setEnabled(canRemove);
                NodesView.this.addNodeAction.setEnabled(canAdd);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.nodeTreeViewer.getControl());
        this.nodeTreeViewer.getControl().setMenu(menu);
        menuMgr.add((IAction)this.refreshNodesAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.addNodeAction);
        menuMgr.add((IAction)this.removeNodeAction);
    }

    private void makeActions() {
        this.refreshNodesAction = new Action(){

            public void run() {
                NodesView.this.nodeTreeViewer.refresh();
            }
        };
        this.refreshNodesAction.setText(SecUIMessages.refreshNodesCommand);
        this.refreshNodesAction.setToolTipText(SecUIMessages.refreshNodesCommandTip);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.security.ui.storage.view.NodesView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.refreshNodesAction.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"/icons/storage/node_refresh.gif"));
        this.addNodeAction = new Action(){

            public void run() {
                TreeSelection selection = (TreeSelection)NodesView.this.nodeTreeViewer.getSelection();
                Object selected = selection.getFirstElement();
                if (selected instanceof ISecurePreferences) {
                    ISecurePreferences node = (ISecurePreferences)selected;
                    NewNodeDialog nodeDialog = new NewNodeDialog(NodesView.this.nodeTreeViewer.getControl().getShell());
                    if (nodeDialog.open() != 0) {
                        return;
                    }
                    String name = nodeDialog.getNodeName();
                    ISecurePreferences child = node.node(name);
                    ISecurePreferences parentNode = child.parent();
                    if (parentNode != null) {
                        NodesView.this.nodeTreeViewer.refresh((Object)parentNode, false);
                    } else {
                        NodesView.this.nodeTreeViewer.refresh(false);
                    }
                    NodesView.this.nodeTreeViewer.expandToLevel((Object)child, 0);
                    NodesView.this.nodeTreeViewer.setSelection((ISelection)new StructuredSelection((Object)child), true);
                }
            }
        };
        this.addNodeAction.setText(SecUIMessages.addNodeCommand);
        this.addNodeAction.setToolTipText(SecUIMessages.addNodeCommandTip);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.security.ui.storage.view.NodesView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addNodeAction.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz2, (String)"/icons/storage/node_new.gif"));
        this.removeNodeAction = new Action(){

            public void run() {
                TreeSelection selection = (TreeSelection)NodesView.this.nodeTreeViewer.getSelection();
                Object selected = selection.getFirstElement();
                if (selected instanceof ISecurePreferences) {
                    ISecurePreferences node = (ISecurePreferences)selected;
                    ISecurePreferences parentNode = node.parent();
                    if (parentNode == null) {
                        return;
                    }
                    node.removeNode();
                    NodesView.this.nodeTreeViewer.refresh((Object)parentNode, false);
                    NodesView.this.nodeTreeViewer.setSelection((ISelection)new StructuredSelection((Object)parentNode), true);
                }
            }
        };
        this.removeNodeAction.setText(SecUIMessages.removeNodeCommand);
        this.removeNodeAction.setToolTipText(SecUIMessages.removeNodeCommandTip);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.equinox.internal.security.ui.storage.view.NodesView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.removeNodeAction.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz3, (String)"/icons/storage/node_delete.gif"));
    }

    public void setFocus() {
        this.nodeTreeViewer.getControl().setFocus();
    }

    public void postDeleted() {
        if (this.contentProvider != null) {
            this.contentProvider.inputChanged(null, null, defaultPrefs);
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (NodesView.this.nodeTreeViewer != null) {
                NodesView.this.nodeTreeViewer.setSelection(null);
                NodesView.this.nodeTreeViewer.refresh();
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (NodesView.defaultPrefs.equals(parent)) {
                return new Object[]{SecurePreferencesFactory.getDefault()};
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (!(child instanceof ISecurePreferences)) {
                return null;
            }
            ISecurePreferences node = (ISecurePreferences)child;
            ISecurePreferences parentNode = node.parent();
            if (parentNode == null) {
                return null;
            }
            return node.parent();
        }

        public Object[] getChildren(Object parent) {
            if (!(parent instanceof ISecurePreferences)) {
                return new Object[0];
            }
            ISecurePreferences node = (ISecurePreferences)parent;
            String[] childrenNames = node.childrenNames();
            Object[] result = new ISecurePreferences[childrenNames.length];
            int i = 0;
            while (i < childrenNames.length) {
                result[i] = node.node(childrenNames[i]);
                ++i;
            }
            return result;
        }

        public boolean hasChildren(Object parent) {
            if (!(parent instanceof ISecurePreferences)) {
                return false;
            }
            ISecurePreferences node = (ISecurePreferences)parent;
            String[] childrenNames = node.childrenNames();
            return childrenNames.length > 0;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            if (!(obj instanceof ISecurePreferences)) {
                return obj.toString();
            }
            ISecurePreferences node = (ISecurePreferences)obj;
            if (node.parent() == null) {
                return String.valueOf('[') + SecUIMessages.rootNodeName + ']';
            }
            return node.name();
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

