/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.storage.friends.PasswordProviderDescription;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.ChangePasswordWizardDialog;
import org.eclipse.equinox.internal.security.ui.storage.PasswordRecoveryDialog;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.service.prefs.BackingStoreException;

public class TabPassword {
    private static final String PREFERENCES_PLUGIN = "org.eclipse.equinox.security";
    private static final String PASSWORD_RECOVERY_NODE = "/org.eclipse.equinox.secure.storage/recovery/";
    protected Table providerTable;
    protected Button buttonClearPassword;
    protected Button buttonChangePassword;
    protected Button buttonRecoverPassword;
    protected boolean providerModified = false;

    public TabPassword(TabFolder folder, int index, final Shell shell, int minButtonWidth) {
        TabItem tab = new TabItem(folder, 0, index);
        tab.setText(SecUIMessages.tabPassword);
        Composite page = new Composite((Composite)folder, 0);
        tab.setControl((Control)page);
        Composite topPart = new Composite(page, 0);
        GridData topData = new GridData(4, 4, true, false);
        topData.horizontalSpan = 2;
        topPart.setLayoutData((Object)topData);
        topPart.setLayout((Layout)new GridLayout(2, false));
        new Label(topPart, 0).setText(SecUIMessages.providerDescription);
        Composite leftPart = new Composite(page, 0);
        leftPart.setLayout((Layout)new GridLayout());
        new Label(leftPart, 0).setText(SecUIMessages.providersTable);
        this.providerTable = new Table(leftPart, 67620);
        GridData tableData = new GridData(4, 4, true, true);
        this.providerTable.setLayoutData((Object)tableData);
        this.providerTable.setLinesVisible(true);
        this.providerTable.setHeaderVisible(true);
        this.fillProviderTable();
        this.providerTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if ((e.detail & 0x20) != 0) {
                    TabPassword.this.providerModified = true;
                }
                TabPassword.this.enableButtons();
            }
        });
        leftPart.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite rightPart = new Composite(page, 0);
        rightPart.setLayout((Layout)new GridLayout());
        this.buttonClearPassword = new Button(rightPart, 0);
        this.buttonClearPassword.setText(SecUIMessages.logoutButton);
        this.buttonClearPassword.setLayoutData((Object)new GridData(4, 2, false, false));
        this.buttonClearPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalExchangeUtils.passwordProvidersReset();
                TabPassword.this.enableLogout();
            }
        });
        this.buttonChangePassword = new Button(rightPart, 0);
        this.buttonChangePassword.setText(SecUIMessages.changePasswordButton);
        this.buttonChangePassword.setLayoutData((Object)new GridData(4, 2, false, false));
        this.buttonChangePassword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String moduleID = TabPassword.this.getSelectedModuleID();
                ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
                ChangePasswordWizardDialog dialog = new ChangePasswordWizardDialog(shell, rootNode, moduleID);
                dialog.open();
                TabPassword.this.enableLogout();
            }
        });
        this.setButtonSize(this.buttonChangePassword, minButtonWidth);
        this.buttonRecoverPassword = new Button(rightPart, 0);
        this.buttonRecoverPassword.setText(SecUIMessages.recoverPasswordButton);
        this.buttonRecoverPassword.setLayoutData((Object)new GridData(4, 2, false, false));
        this.buttonRecoverPassword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String moduleID = TabPassword.this.getSelectedModuleID();
                ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
                String[] questions = InternalExchangeUtils.getPasswordRecoveryQuestions((ISecurePreferences)rootNode, (String)moduleID);
                if (questions.length == 0) {
                    return;
                }
                PasswordRecoveryDialog dialog = new PasswordRecoveryDialog(questions, shell, moduleID);
                dialog.open();
                TabPassword.this.enableLogout();
            }
        });
        this.setButtonSize(this.buttonRecoverPassword, minButtonWidth);
        this.enableButtons();
        rightPart.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(2).generateLayout(page);
    }

    private void fillProviderTable() {
        TableColumn enabledColumn = new TableColumn(this.providerTable, 0x1000000);
        enabledColumn.setText(SecUIMessages.enabledColumn);
        enabledColumn.setWidth(60);
        TableColumn priorityColumn = new TableColumn(this.providerTable, 16384);
        priorityColumn.setText(SecUIMessages.priorityColumn);
        priorityColumn.setWidth(60);
        TableColumn idColumn = new TableColumn(this.providerTable, 16384);
        idColumn.setText(SecUIMessages.idColumn);
        idColumn.setWidth(300);
        List availableModules = InternalExchangeUtils.passwordProvidersFind();
        HashSet disabledModules = this.getDisabledModules();
        Iterator i = availableModules.iterator();
        while (i.hasNext()) {
            PasswordProviderDescription module = (PasswordProviderDescription)i.next();
            TableItem item = new TableItem(this.providerTable, 16384);
            String[] stringArray = new String[3];
            stringArray[1] = Integer.toString(module.getPriority());
            stringArray[2] = module.getName();
            item.setText(stringArray);
            item.setData((Object)module.getId());
            if (disabledModules == null) {
                item.setChecked(true);
                continue;
            }
            item.setChecked(!disabledModules.contains(module.getId()));
        }
    }

    protected String getSelectedModuleID() {
        if (this.providerTable == null) {
            return null;
        }
        TableItem[] items = this.providerTable.getSelection();
        if (items.length == 0) {
            return null;
        }
        return (String)items[0].getData();
    }

    protected void enableButtons() {
        String moduleID = this.getSelectedModuleID();
        if (moduleID == null) {
            this.buttonChangePassword.setEnabled(false);
            this.buttonRecoverPassword.setEnabled(false);
        } else {
            this.buttonChangePassword.setEnabled(true);
            ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
            String path = PASSWORD_RECOVERY_NODE + moduleID;
            boolean recoveryAvailable = rootNode.nodeExists(path);
            this.buttonRecoverPassword.setEnabled(recoveryAvailable);
        }
        this.enableLogout();
    }

    protected HashSet getDisabledModules() {
        IEclipsePreferences node = new ConfigurationScope().getNode(PREFERENCES_PLUGIN);
        String tmp = node.get("org.eclipse.equinox.security.preferences.disabledProviders", null);
        if (tmp == null || tmp.length() == 0) {
            return null;
        }
        HashSet<String> modules = new HashSet<String>();
        String[] disabledProviders = tmp.split(",");
        int i = 0;
        while (i < disabledProviders.length) {
            modules.add(disabledProviders[i]);
            ++i;
        }
        return modules;
    }

    public void performDefaults() {
        if (this.providerTable == null) {
            return;
        }
        TableItem[] items = this.providerTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (!items[i].getChecked()) {
                items[i].setChecked(true);
                this.providerModified = true;
            }
            ++i;
        }
    }

    public void performOk() {
        if (!this.providerModified) {
            return;
        }
        StringBuffer tmp = new StringBuffer();
        boolean first = true;
        TableItem[] items = this.providerTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (!items[i].getChecked()) {
                if (!first) {
                    tmp.append(',');
                } else {
                    first = false;
                }
                tmp.append((String)items[i].getData());
            }
            ++i;
        }
        IEclipsePreferences node = new ConfigurationScope().getNode(PREFERENCES_PLUGIN);
        if (first) {
            node.remove("org.eclipse.equinox.security.preferences.disabledProviders");
        } else {
            node.put("org.eclipse.equinox.security.preferences.disabledProviders", tmp.toString());
        }
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        InternalExchangeUtils.passwordProvidersReset();
    }

    public void onActivated() {
        this.enableLogout();
    }

    protected void enableLogout() {
        this.buttonClearPassword.setEnabled(InternalExchangeUtils.isLoggedIn());
    }

    protected void setButtonSize(Button button, int minButtonWidth) {
        Dialog.applyDialogFont((Control)button);
        GridData data = new GridData();
        Point minButtonSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(minButtonWidth, minButtonSize.x);
        button.setLayoutData((Object)data);
    }
}

