/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PasswordRecoveryDialog
extends TitleAreaDialog {
    private static final String HELP_ID = "org.eclipse.equinox.security.ui.PasswordRecoveryDialog";
    protected Text[] answers;
    protected String moduleID;
    protected String[] answersText = null;
    protected Button okButton;
    protected final String[] questionsText;

    public PasswordRecoveryDialog(String[] questionsText, Shell parentShell, String moduleID) {
        super(parentShell);
        this.questionsText = questionsText;
        this.moduleID = moduleID;
        this.answers = new Text[questionsText.length];
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SecUIMessages.pswdRecoveryTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELP_ID);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, SecUIMessages.pswRecoveryButtonOK, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, SecUIMessages.pswRecoveryButtonCancel, false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeTop = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(compositeTop, 0);
        this.setMessage(SecUIMessages.pswRecoveryMsg, 1);
        int i = 0;
        while (i < this.questionsText.length) {
            Group group = new Group(composite, 0);
            group.setText(NLS.bind((String)SecUIMessages.passwordGroup, (Object)Integer.toString(i + 1)));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setLayout((Layout)new GridLayout());
            String question = NLS.bind((String)SecUIMessages.pswRecoveryQuestion, (Object)this.questionsText[i]);
            new Label((Composite)group, 16384).setText(question);
            this.answers[i] = new Text((Composite)group, 18432);
            this.answers[i].setLayoutData((Object)new GridData(4, 4, true, true));
            this.answers[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    PasswordRecoveryDialog.this.validateOK();
                }
            });
            ++i;
        }
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.swtDefaults().generateLayout(composite);
        return composite;
    }

    protected void validateOK() {
        boolean valid = true;
        int i = 0;
        while (i < this.questionsText.length) {
            String question;
            if (this.answers[i] != null && ((question = this.answers[i].getText()) == null || question.length() == 0)) {
                valid = false;
                break;
            }
            ++i;
        }
        if (valid) {
            this.setMessage(SecUIMessages.pswRecoveryMsg, 1);
        } else {
            this.setMessage(SecUIMessages.pswRecoveryWarning, 2);
        }
        this.okButton.setEnabled(valid);
    }

    protected void okPressed() {
        this.answersText = new String[this.questionsText.length];
        int i = 0;
        while (i < this.questionsText.length) {
            this.answersText[i] = this.answers[i].getText();
            ++i;
        }
        String password = InternalExchangeUtils.recoverPassword((String[])this.answersText, (ISecurePreferences)SecurePreferencesFactory.getDefault(), (String)this.moduleID);
        if (password == null) {
            MessageBox prompt = new MessageBox(this.getShell(), 193);
            prompt.setText(SecUIMessages.pswdRecoveryTitle);
            prompt.setMessage(SecUIMessages.pswNotRecoveredMsg);
            if (prompt.open() == 64) {
                return;
            }
        } else {
            MessageBox prompt = new MessageBox(this.getShell(), 34);
            prompt.setText(SecUIMessages.pswdRecoveryTitle);
            prompt.setMessage(SecUIMessages.pswRecoveredMsg);
            prompt.open();
        }
        super.okPressed();
    }

    public String[] getResult() {
        return this.answersText;
    }
}

