/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ChallengeResponseDialog
extends TitleAreaDialog {
    private static final String HELP_ID = "org.eclipse.equinox.security.ui.ChallengeResponseDialog";
    protected Text[] questions;
    protected Text[] answers;
    protected String[] questionsText = null;
    protected String[] answersText = null;
    protected Button okButton;
    protected final int size;

    public ChallengeResponseDialog(int numberOfQuestions, Shell parentShell) {
        super(parentShell);
        this.size = numberOfQuestions;
        this.questions = new Text[this.size];
        this.answers = new Text[this.size];
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SecUIMessages.passwordRecoveryTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELP_ID);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, SecUIMessages.passwordButtonOK, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, SecUIMessages.passwordButtonCancel, false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeTop = (Composite)super.createDialogArea(parent);
        this.setTitle(SecUIMessages.passwordRecoveryTitleMsg);
        Composite composite = new Composite(compositeTop, 0);
        this.setMessage(SecUIMessages.passwordMsg, 1);
        int i = 0;
        while (i < this.size) {
            Group group = new Group(composite, 0);
            group.setText(NLS.bind((String)SecUIMessages.passwordGroup, (Object)Integer.toString(i + 1)));
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)new GridLayout(2, false));
            new Label((Composite)group, 16384).setText(SecUIMessages.passwordQuestion);
            this.questions[i] = new Text((Composite)group, 18432);
            this.questions[i].setLayoutData((Object)new GridData(4, 4, true, false));
            this.questions[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    ChallengeResponseDialog.this.validateOK();
                }
            });
            new Label((Composite)group, 16384).setText(SecUIMessages.passwordAnswer);
            this.answers[i] = new Text((Composite)group, 18432);
            this.answers[i].setLayoutData((Object)new GridData(4, 4, true, false));
            this.answers[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    ChallengeResponseDialog.this.validateOK();
                }
            });
            ++i;
        }
        Label storyLabel = new Label(composite, 16384);
        storyLabel.setText(SecUIMessages.passwordRecoveryLabel);
        storyLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.swtDefaults().generateLayout(composite);
        return composite;
    }

    protected void validateOK() {
        boolean valid = true;
        int i = 0;
        while (i < this.size) {
            if (this.questions[i] != null) {
                String answer;
                String question = this.questions[i].getText();
                if (question == null || question.length() == 0) {
                    valid = false;
                    break;
                }
                if (this.answers[i] != null && ((answer = this.answers[i].getText()) == null || answer.length() == 0)) {
                    valid = false;
                    break;
                }
            }
            ++i;
        }
        if (valid) {
            this.setMessage(SecUIMessages.passwordMsg, 1);
        } else {
            this.setMessage(SecUIMessages.passwordErrMsg, 2);
        }
        this.okButton.setEnabled(valid);
    }

    protected void okPressed() {
        this.questionsText = new String[this.size];
        this.answersText = new String[this.size];
        int i = 0;
        while (i < this.size) {
            this.questionsText[i] = this.questions[i].getText();
            this.answersText[i] = this.answers[i].getText();
            ++i;
        }
        super.okPressed();
    }

    public String[][] getResult() {
        if (this.questionsText == null || this.answersText == null) {
            return null;
        }
        return new String[][]{this.questionsText, this.answersText};
    }
}

