/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.preferences;

import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine;
import org.eclipse.osgi.internal.service.security.DefaultAuthorizationEngine;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PolicyPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button anyButton;
    Button anysignedButton;
    Button onlytrustedButton;
    Button expiredButton;
    private int selectedPolicy;
    private static final int BIT_TRUST_EXPIRED = 7;
    private static final int BIT_TRUST = 3;

    protected Control createContents(Composite parent) {
        AuthorizationEngine authEngine;
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(272));
        Group buttonGroup = new Group(composite, 16384);
        GridLayout buttonLayout = new GridLayout();
        buttonGroup.setLayout((Layout)buttonLayout);
        GridData compositeData = new GridData(768);
        buttonGroup.setLayoutData((Object)compositeData);
        buttonGroup.setText(SecurityUIMsg.POLPAGE_LABEL_DESC);
        this.anyButton = new Button((Composite)buttonGroup, 16);
        this.anysignedButton = new Button((Composite)buttonGroup, 16);
        this.onlytrustedButton = new Button((Composite)buttonGroup, 16);
        this.expiredButton = new Button((Composite)buttonGroup, 32);
        this.expiredButton.setEnabled(true);
        GridData data = new GridData();
        data.horizontalIndent = 20;
        this.expiredButton.setLayoutData((Object)data);
        this.expiredButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (PolicyPage.this.expiredButton.getSelection()) {
                    PolicyPage.this.persistPolicySetting(7);
                } else {
                    PolicyPage.this.persistPolicySetting(3);
                }
            }
        });
        if (System.getProperty("osgi.signedcontent.support") != null && (authEngine = Activator.getAuthorizationEngine()) instanceof DefaultAuthorizationEngine) {
            DefaultAuthorizationEngine defaultAuthEngine = (DefaultAuthorizationEngine)authEngine;
            this.selectedPolicy = defaultAuthEngine.getLoadPolicy();
            if ((this.selectedPolicy & 7) == 7) {
                this.onlytrustedButton.setSelection(true);
                this.expiredButton.setSelection(true);
                this.expiredButton.setEnabled(true);
            } else if ((this.selectedPolicy & 3) == 3) {
                this.onlytrustedButton.setSelection(true);
                this.expiredButton.setEnabled(true);
            } else if ((this.selectedPolicy & 1) == 1) {
                this.anysignedButton.setSelection(true);
            } else if (!false) {
                this.anyButton.setSelection(true);
            }
        }
        this.anyButton.setText(SecurityUIMsg.POLPAGE_BUTTON_ALLOW_ANY);
        this.anyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                PolicyPage.this.expiredButton.setEnabled(false);
                PolicyPage.this.expiredButton.setSelection(false);
                PolicyPage.this.persistPolicySetting(0);
            }
        });
        this.anysignedButton.setText(SecurityUIMsg.POLPAGE_BUTTON_ALLOW_ANY_SIGNED);
        this.anysignedButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                PolicyPage.this.expiredButton.setSelection(false);
                PolicyPage.this.expiredButton.setEnabled(false);
                PolicyPage.this.persistPolicySetting(1);
            }
        });
        this.onlytrustedButton.setText(SecurityUIMsg.POLPAGE_BUTTON_ALLOW_ONLY_TRUSTED);
        this.onlytrustedButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                PolicyPage.this.expiredButton.setEnabled(true);
                PolicyPage.this.persistPolicySetting(3);
            }
        });
        this.expiredButton.setText(SecurityUIMsg.POLPAGE_BUTTON_ALLOW_EXPIRED);
        return composite;
    }

    public boolean performOk() {
        AuthorizationEngine authEngine = Activator.getAuthorizationEngine();
        if (authEngine instanceof DefaultAuthorizationEngine) {
            DefaultAuthorizationEngine defaultAuthEngine = (DefaultAuthorizationEngine)authEngine;
            defaultAuthEngine.setLoadPolicy(this.selectedPolicy);
        }
        return super.performOk();
    }

    void persistPolicySetting(int policy) {
        this.selectedPolicy = policy;
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }
}

