/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui;

import java.security.Security;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.security.ui.AuthorizationManager;
import org.eclipse.equinox.internal.security.ui.DefaultAuthorizationManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.equinox.security.ui";
    private static final String PROP_TRUST_ENGINE = "osgi.signedcontent.trust.engine";
    private static final String PROP_AUTHZ_ENGINE = "osgi.signedcontent.authorization.engine";
    private static final String PROP_AUTHZ_MANAGER = "osgi.signedcontent.authorization.manager";
    private static final String PROP_DEFAULT_SERVICE = "org.eclipse.osgi";
    private static ServiceTracker trustEngineTracker;
    private static ServiceTracker authzEngineTracker;
    private static ServiceTracker authzManagerTracker;
    private static ServiceTracker platformAdminTracker;
    private static ServiceTracker debugTracker;
    private static Activator plugin;
    private static BundleContext bundleContext;
    private ServiceRegistration defaultAuthzManagerReg;
    private static final String OPTION_DEBUG = "org.eclipse.equinox.security.ui/debug";
    private static final String OPTION_DEBUG_STORAGE = "org.eclipse.equinox.security.ui/debug/storage";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getSymbolicName() {
        return plugin.getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bundleContext = context;
        plugin = this;
        Hashtable<String, Object> properties = new Hashtable<String, Object>(7);
        properties.put("service.ranking", new Integer(Integer.MIN_VALUE));
        properties.put(PROP_AUTHZ_MANAGER, PROP_DEFAULT_SERVICE);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.security.ui.AuthorizationManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.defaultAuthzManagerReg = bundleContext.registerService(clazz.getName(), (Object)new DefaultAuthorizationManager(), properties);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        bundleContext = null;
        plugin = null;
        if (this.defaultAuthzManagerReg != null) {
            this.defaultAuthzManagerReg.unregister();
            this.defaultAuthzManagerReg = null;
        }
        if (authzEngineTracker != null) {
            authzEngineTracker.close();
            authzEngineTracker = null;
        }
        if (authzManagerTracker != null) {
            authzManagerTracker.close();
            authzManagerTracker = null;
        }
        if (platformAdminTracker != null) {
            platformAdminTracker.close();
            platformAdminTracker = null;
        }
        if (debugTracker != null) {
            debugTracker.close();
            debugTracker = null;
        }
    }

    public static TrustEngine[] getTrustEngines() {
        Object[] services;
        if (trustEngineTracker == null) {
            String trustAuthorityProp = Security.getProperty(PROP_TRUST_ENGINE);
            Filter filter = null;
            if (trustAuthorityProp != null) {
                try {
                    StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    filter = FrameworkUtil.createFilter((String)stringBuffer.append(clazz.getName()).append(")(").append(PROP_TRUST_ENGINE).append("=").append(trustAuthorityProp).append("))").toString());
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (filter != null) {
                trustEngineTracker = new ServiceTracker(bundleContext, filter, null);
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                trustEngineTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            }
            trustEngineTracker.open();
        }
        if ((services = trustEngineTracker.getServices()) != null) {
            return Arrays.asList(services).toArray(new TrustEngine[0]);
        }
        return new TrustEngine[0];
    }

    public static AuthorizationEngine getAuthorizationEngine() {
        if (authzEngineTracker == null) {
            String implProp = Security.getProperty(PROP_AUTHZ_ENGINE);
            Filter filter = null;
            if (implProp != null) {
                try {
                    StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    filter = FrameworkUtil.createFilter((String)stringBuffer.append(clazz.getName()).append(")(").append(PROP_AUTHZ_ENGINE).append("=").append(implProp).append("))").toString());
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
            }
            if (filter != null) {
                authzEngineTracker = new ServiceTracker(Activator.getBundleContext(), filter, null);
            } else {
                BundleContext bundleContext = Activator.getBundleContext();
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                authzEngineTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            }
            authzEngineTracker.open();
        }
        return (AuthorizationEngine)authzEngineTracker.getService();
    }

    public static AuthorizationManager getAuthorizationManager() {
        if (authzManagerTracker == null) {
            String implProp = Security.getProperty(PROP_AUTHZ_MANAGER);
            Filter filter = null;
            if (implProp != null) {
                try {
                    StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.security.ui.AuthorizationManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    filter = FrameworkUtil.createFilter((String)stringBuffer.append(clazz.getName()).append(")(").append(PROP_AUTHZ_MANAGER).append("=").append(implProp).append("))").toString());
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
            }
            if (filter != null) {
                authzManagerTracker = new ServiceTracker(Activator.getBundleContext(), filter, null);
            } else {
                BundleContext bundleContext = Activator.getBundleContext();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.security.ui.AuthorizationManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                authzManagerTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            }
            authzManagerTracker.open();
        }
        return (AuthorizationManager)authzManagerTracker.getService();
    }

    public static PlatformAdmin getPlatformAdmin() {
        if (platformAdminTracker == null) {
            BundleContext bundleContext = Activator.getBundleContext();
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            platformAdminTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            platformAdminTracker.open();
        }
        return (PlatformAdmin)platformAdminTracker.getService();
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons" + relativePath));
    }

    public static void log(int severity, String key, Object[] args, Throwable throwable) {
        plugin.getLog().log((IStatus)new Status(severity, Activator.getSymbolicName(), 0, NLS.bind((String)key, (Object[])args), throwable));
    }

    public DebugOptions getDebugOptions() {
        if (debugTracker == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            debugTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            debugTracker.open();
        }
        return (DebugOptions)debugTracker.getService();
    }

    public boolean debugStorageContents() {
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return false;
        }
        return debugOptions.getBooleanOption(OPTION_DEBUG, false) && debugOptions.getBooleanOption(OPTION_DEBUG_STORAGE, false);
    }
}

