/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.resource;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ltk.internal.core.refactoring.Resources;
import org.eclipse.ltk.internal.core.refactoring.resource.DeleteResourcesProcessor;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DeleteResourcesWizard
extends RefactoringWizard {
    static /* synthetic */ Class class$0;

    public DeleteResourcesWizard(IResource[] resources) {
        super((Refactoring)new DeleteRefactoring((DeleteProcessor)new DeleteResourcesProcessor(resources, false)), 4);
        this.setDefaultPageTitle(RefactoringUIMessages.DeleteResourcesWizard_page_title);
        this.setWindowTitle(RefactoringUIMessages.DeleteResourcesWizard_window_title);
    }

    protected void addUserInputPages() {
        Refactoring refactoring = this.getRefactoring();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.internal.core.refactoring.resource.DeleteResourcesProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DeleteResourcesProcessor processor = (DeleteResourcesProcessor)refactoring.getAdapter((Class)clazz);
        this.addPage((IWizardPage)new DeleteResourcesRefactoringConfigurationPage(processor));
    }

    private static class DeleteResourcesRefactoringConfigurationPage
    extends UserInputWizardPage {
        private DeleteResourcesProcessor fRefactoringProcessor;
        private Button fDeleteContentsButton;

        public DeleteResourcesRefactoringConfigurationPage(DeleteResourcesProcessor processor) {
            super("DeleteResourcesRefactoringConfigurationPage");
            this.fRefactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Point defaultSpacing = LayoutConstants.getSpacing();
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.horizontalSpacing = defaultSpacing.x * 2;
            gridLayout.verticalSpacing = defaultSpacing.y;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Image image = parent.getDisplay().getSystemImage(4);
            Label imageLabel = new Label(composite, 0);
            imageLabel.setBackground(image.getBackground());
            imageLabel.setImage(image);
            imageLabel.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
            IResource[] resources = this.fRefactoringProcessor.getResourcesToDelete();
            Label label = new Label(composite, 64);
            label.setFont(composite.getFont());
            if (resources.length == 1) {
                label.setText(Messages.format(RefactoringUIMessages.DeleteResourcesWizard_label_single, resources[0].getName()));
            } else {
                label.setText(Messages.format(RefactoringUIMessages.DeleteResourcesWizard_label_multi, new Integer(resources.length)));
            }
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)gridData);
            Composite supportArea = new Composite(composite, 0);
            supportArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            gridLayout = new GridLayout(1, false);
            gridLayout.horizontalSpacing = defaultSpacing.x * 2;
            gridLayout.verticalSpacing = defaultSpacing.y;
            supportArea.setLayout((Layout)gridLayout);
            if (Resources.containsOnlyProjects((IResource[])resources)) {
                this.fDeleteContentsButton = new Button(supportArea, 32);
                this.fDeleteContentsButton.setFont(composite.getFont());
                this.fDeleteContentsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                this.fDeleteContentsButton.setText(RefactoringUIMessages.DeleteResourcesWizard_project_deleteContents);
                this.fDeleteContentsButton.setFocus();
            }
            this.setControl((Control)composite);
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            this.fRefactoringProcessor.setDeleteContents(this.fDeleteContentsButton == null ? false : this.fDeleteContentsButton.getSelection());
        }

        private void storeSettings() {
        }
    }
}

