/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net.proxy.unix;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.net.proxy.IProxyData;

public class UnixProxyProvider
extends AbstractProxyProvider {
    public static boolean DEBUG = false;
    private static boolean isGnomeLibLoaded = false;

    public IProxyData[] getProxyData(URI uri) {
        IProxyData[] iProxyDataArray;
        ProxyData pd = this.getSystemProxyInfo(uri.getScheme());
        if (pd != null) {
            IProxyData[] iProxyDataArray2 = new IProxyData[1];
            iProxyDataArray = iProxyDataArray2;
            iProxyDataArray2[0] = pd;
        } else {
            iProxyDataArray = new IProxyData[]{};
        }
        return iProxyDataArray;
    }

    public String[] getNonProxiedHosts() {
        String npEnv = this.getEnv("no_proxy");
        if (npEnv != null) {
            String[] npHosts = npEnv.split(",");
            int i = 0;
            while (i < npHosts.length) {
                npHosts[i] = npHosts[i].trim();
                ++i;
            }
            if (DEBUG) {
                System.out.println("got env no_proxy: " + npEnv);
                this.debugPrint(npHosts);
            }
            return npHosts;
        }
        try {
            UnixProxyProvider.loadGnomeLib();
            String[] npHosts = UnixProxyProvider.getGConfNonProxyHosts();
            if (npHosts != null && npHosts.length > 0) {
                if (DEBUG) {
                    System.out.println("got gnome no_proxy");
                    this.debugPrint(npHosts);
                }
                return npHosts;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        return new String[0];
    }

    protected ProxyData getSystemProxyInfo(String protocol) {
        ProxyData pd = null;
        String envName = null;
        try {
            if (DEBUG) {
                System.out.println("getting ProxyData for: " + protocol);
            }
            protocol = protocol.toLowerCase(Locale.ENGLISH);
            envName = String.valueOf(protocol) + "_proxy";
            String proxyEnv = this.getEnv(envName);
            if (DEBUG) {
                System.out.println("got proxyEnv: " + proxyEnv);
            }
            if (proxyEnv != null) {
                URI uri = new URI(proxyEnv);
                pd = new ProxyData(protocol);
                pd.setHost(uri.getHost());
                pd.setPort(uri.getPort());
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String user = null;
                    String password = null;
                    int pwInd = userInfo.indexOf(58);
                    if (pwInd >= 0) {
                        user = userInfo.substring(0, pwInd);
                        password = userInfo.substring(pwInd + 1);
                    } else {
                        user = userInfo;
                    }
                    pd.setUserid(user);
                    pd.setPassword(password);
                }
                if (DEBUG) {
                    System.out.println("env proxy data: " + pd);
                }
                return pd;
            }
        }
        catch (Exception ex) {
            Activator.logError("Problem during accessing system variable: " + envName, ex);
        }
        try {
            UnixProxyProvider.loadGnomeLib();
            pd = UnixProxyProvider.getGConfProxyInfo(protocol);
            if (DEBUG) {
                System.out.println("Gnome proxy data: " + pd);
            }
            return pd;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return null;
        }
    }

    private String getEnv(String env) {
        Properties props = new Properties();
        try {
            props.load(Runtime.getRuntime().exec("env").getInputStream());
        }
        catch (IOException e) {
            Activator.logError("Problem during accessing system variable: " + env, e);
        }
        return props.getProperty(env);
    }

    private static void loadGnomeLib() {
        block4: {
            if (!isGnomeLibLoaded) {
                try {
                    System.loadLibrary("proxygnome");
                    UnixProxyProvider.gconfInit();
                    isGnomeLibLoaded = true;
                    if (DEBUG) {
                        System.out.println("Loaded (Gnome) libraries");
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (!DEBUG) break block4;
                    System.out.println("Missing gconf (Gnome) libraries");
                }
            }
        }
    }

    private void debugPrint(String[] strs) {
        System.out.println("npHosts: ");
        int i = 0;
        while (i < strs.length) {
            System.out.println(String.valueOf(i) + ": " + strs[i]);
            ++i;
        }
    }

    protected static native void gconfInit();

    protected static native ProxyData getGConfProxyInfo(String var0);

    protected static native String[] getGConfNonProxyHosts();
}

