/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.Utils;

public class SimpleConfiguratorUtils {
    public static List readConfiguration(URL url) throws IOException {
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                URL baseUrl = new URL(url, "./");
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
                    if (line.startsWith("org.eclipse.equinox.simpleconfigurator.baseUrl=")) {
                        String baseUrlSt = line.substring("org.eclipse.equinox.simpleconfigurator.baseUrl=".length());
                        if (!baseUrlSt.endsWith("/")) {
                            baseUrlSt = String.valueOf(baseUrlSt) + "/";
                        }
                        baseUrl = new URL(url, baseUrlSt);
                        continue;
                    }
                    StringTokenizer tok = new StringTokenizer(line, ",", true);
                    String symbolicName = tok.nextToken();
                    if (symbolicName.equals(",")) {
                        symbolicName = null;
                    } else {
                        tok.nextToken();
                    }
                    String version = tok.nextToken();
                    if (version.equals(",")) {
                        version = null;
                    } else {
                        tok.nextToken();
                    }
                    String urlSt = tok.nextToken();
                    if (urlSt.equals(",")) {
                        urlSt = symbolicName != null && version != null ? String.valueOf(symbolicName) + "_" + version + ".jar" : null;
                    } else {
                        tok.nextToken();
                    }
                    try {
                        new URL(urlSt);
                    }
                    catch (MalformedURLException malformedURLException) {
                        urlSt = Utils.getUrlInFull(urlSt, baseUrl).toExternalForm();
                    }
                    int sl = Integer.parseInt(tok.nextToken().trim());
                    tok.nextToken();
                    boolean markedAsStarted = Boolean.valueOf(tok.nextToken());
                    BundleInfo bInfo = new BundleInfo(symbolicName, version, urlSt, sl, markedAsStarted);
                    bundles.add(bInfo);
                }
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return bundles;
    }

    public static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead != -1) {
                    destination.write(buffer, 0, bytesRead);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            source.close();
        }
        catch (IOException iOException) {}
        try {
            destination.close();
        }
        catch (IOException iOException) {}
    }
}

