/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Display;

class MozillaDelegate {
    Browser browser;

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(int handle) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(handle);
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        char[] chars = new char[buffer.length];
        int charCount = OS.MultiByteToWideChar(0, 1, buffer, buffer.length, chars, chars.length);
        if (charCount == chars.length) {
            return chars;
        }
        char[] result = new char[charCount];
        System.arraycopy(chars, 0, result, 0, charCount);
        return result;
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int byteCount = chars.length * 2 + (terminate ? 1 : 0);
        byte[] bytes = new byte[byteCount];
        byteCount = OS.WideCharToMultiByte(0, 0, chars, chars.length, bytes, byteCount, null, null);
        if (terminate) {
            ++byteCount;
        } else if (bytes.length != byteCount) {
            byte[] result = new byte[byteCount];
            System.arraycopy(bytes, 0, result, 0, byteCount);
            bytes = result;
        }
        return bytes;
    }

    int getHandle() {
        return this.browser.handle;
    }

    String getLibraryName() {
        return "xpcom.dll";
    }

    String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    void handleFocus() {
    }

    void handleMouseDown() {
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
    }

    boolean needsSpinup() {
        return false;
    }

    void onDispose(int embedHandle) {
        this.browser = null;
    }

    void setSize(int embedHandle, int width, int height) {
    }
}

