/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditorPreferenceConstants;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class EditorsPluginPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
        TextEditorPreferenceConstants.initializeDefaultValues(store);
        this.migrateOverviewRulerPreference(store);
    }

    public static void setThemeBasedPreferences(IPreferenceStore store, boolean fireEvent) {
        ColorRegistry registry = null;
        if (PlatformUI.isWorkbenchRunning()) {
            registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        }
        EditorsPluginPreferenceInitializer.setDefault(store, "currentLineColor", EditorsPluginPreferenceInitializer.findRGB(registry, "org.eclipse.ui.editors.currentLineColor", new RGB(232, 242, 254)), fireEvent);
        EditorsPluginPreferenceInitializer.setDefault(store, "printMarginColor", EditorsPluginPreferenceInitializer.findRGB(registry, "org.eclipse.ui.editors.printMarginColor", new RGB(176, 180, 185)), fireEvent);
        EditorsPluginPreferenceInitializer.setDefault(store, "lineNumberColor", EditorsPluginPreferenceInitializer.findRGB(registry, "org.eclipse.ui.editors.lineNumberRulerColor", new RGB(120, 120, 120)), fireEvent);
        EditorsPluginPreferenceInitializer.setDefault(store, "AbstractTextEditor.Color.Background", EditorsPluginPreferenceInitializer.findRGB(registry, "org.eclipse.ui.editors.backgroundColor", new RGB(255, 255, 255)), fireEvent);
        EditorsPluginPreferenceInitializer.setDefault(store, "AbstractTextEditor.Color.Foreground", EditorsPluginPreferenceInitializer.findRGB(registry, "org.eclipse.ui.editors.foregroundColor", new RGB(0, 0, 0)), fireEvent);
        EditorsPluginPreferenceInitializer.setDefault(store, "hyperlinkColor", EditorsPluginPreferenceInitializer.findRGB(registry, "org.eclipse.ui.editors.hyperlinkColor", new RGB(0, 0, 255)), fireEvent);
        EditorsPluginPreferenceInitializer.setDefault(store, "AbstractTextEditor.Color.FindScope", EditorsPluginPreferenceInitializer.findRGB(registry, "org.eclipse.ui.editors.findScope", new RGB(185, 176, 180)), fireEvent);
    }

    private static void setDefault(IPreferenceStore store, String key, RGB newValue, boolean fireEvent) {
        if (!fireEvent) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        }
        RGB oldValue = null;
        if (store.isDefault(key)) {
            oldValue = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        if (oldValue != null && !oldValue.equals((Object)newValue)) {
            store.firePropertyChangeEvent(key, (Object)oldValue, (Object)newValue);
        }
    }

    private static RGB findRGB(ColorRegistry registry, String key, RGB defaultRGB) {
        if (registry == null) {
            return defaultRGB;
        }
        RGB rgb = registry.getRGB(key);
        if (rgb != null) {
            return rgb;
        }
        return defaultRGB;
    }

    private void migrateOverviewRulerPreference(IPreferenceStore store) {
        String preference = "overviewRuler";
        String postfix = "_migration";
        String MIGRATED = "migrated_3.1";
        String migrationKey = String.valueOf(preference) + postfix;
        String migrationValue = store.getString(migrationKey);
        if (!MIGRATED.equals(migrationValue)) {
            store.putValue(migrationKey, MIGRATED);
            if (!store.getBoolean(preference)) {
                store.putValue(preference, Boolean.TRUE.toString());
            }
        }
    }
}

