/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.Headers;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Activator;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.AggregatedBundleRepository;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointData;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Util {
    private static final String REPOSITORY_TYPE = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
    private static final String CACHE_EXTENSIONS = "org.eclipse.equinox.p2.cache.extensions";
    private static final String PIPE = "|";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static AgentLocation getAgentLocation() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    public static URL getBundlePoolLocation(IProfile profile) {
        AgentLocation location;
        String path = profile.getProperty("org.eclipse.equinox.p2.cache");
        if (path != null) {
            try {
                return new File(path).toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if ((location = Util.getAgentLocation()) == null) {
            return null;
        }
        return location.getDataArea("org.eclipse.equinox.p2.touchpoint.eclipse");
    }

    public static synchronized IFileArtifactRepository getBundlePoolRepository(IProfile profile) {
        URL location = Util.getBundlePoolLocation(profile);
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager();
        try {
            return (IFileArtifactRepository)manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            try {
                String repositoryName = Messages.BundlePool;
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("p2.system", Boolean.TRUE.toString());
                IArtifactRepository bundlePool = manager.createRepository(location, repositoryName, REPOSITORY_TYPE, properties);
                manager.addRepository(bundlePool.getLocation());
                bundlePool = manager.loadRepository(bundlePool.getLocation(), null);
                return (IFileArtifactRepository)bundlePool;
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalArgumentException(NLS.bind((String)Messages.bundle_pool_not_writeable, (Object)location));
            }
        }
    }

    public static IFileArtifactRepository getAggregatedBundleRepository(IProfile profile) {
        HashSet<Object> bundleRepositories = new HashSet<Object>();
        bundleRepositories.add(Util.getBundlePoolRepository(profile));
        IArtifactRepositoryManager manager = Util.getArtifactRepositoryManager();
        List extensions = Util.getListProfileProperty(profile, CACHE_EXTENSIONS);
        String sharedCache = profile.getProperty("org.eclipse.equinox.p2.cache.shared");
        if (sharedCache != null) {
            try {
                extensions.add(new File(sharedCache).toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
            }
        }
        Iterator iterator = extensions.iterator();
        while (iterator.hasNext()) {
            try {
                String extension = (String)iterator.next();
                URL extensionURL = new URL(extension);
                IArtifactRepository repository = manager.loadRepository(extensionURL, null);
                if (repository == null) continue;
                bundleRepositories.add(repository);
            }
            catch (ProvisionException provisionException) {
            }
            catch (MalformedURLException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
            }
        }
        return new AggregatedBundleRepository(bundleRepositories);
    }

    private static List getListProfileProperty(IProfile profile, String key) {
        ArrayList<String> listProperty = new ArrayList<String>();
        String dropinRepositories = profile.getProperty(key);
        if (dropinRepositories != null) {
            StringTokenizer tokenizer = new StringTokenizer(dropinRepositories, PIPE);
            while (tokenizer.hasMoreTokens()) {
                listProperty.add(tokenizer.nextToken());
            }
        }
        return listProperty;
    }

    public static BundleInfo createBundleInfo(File bundleFile, String manifest) {
        String version;
        BundleInfo bundleInfo;
        block8: {
            ManifestElement[] element;
            Headers headers;
            block7: {
                bundleInfo = new BundleInfo();
                try {
                    if (bundleFile != null) {
                        bundleInfo.setLocation(bundleFile.toURL().toExternalForm());
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                bundleInfo.setManifest(manifest);
                try {
                    headers = Headers.parseManifest((InputStream)new ByteArrayInputStream(manifest.getBytes()));
                    element = ManifestElement.parseHeader((String)"bsn", (String)((String)headers.get((Object)"Bundle-SymbolicName")));
                    if (element != null && element.length != 0) break block7;
                    return null;
                }
                catch (BundleException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", e.getMessage(), (Throwable)e));
                    return null;
                }
            }
            bundleInfo.setSymbolicName(element[0].getValue());
            version = (String)headers.get((Object)"Bundle-Version");
            if (version != null) break block8;
            return null;
        }
        bundleInfo.setVersion(version);
        return bundleInfo;
    }

    public static File getArtifactFile(IArtifactKey artifactKey, IProfile profile) {
        IFileArtifactRepository aggregatedView = Util.getAggregatedBundleRepository(profile);
        File bundleJar = aggregatedView.getArtifactFile(artifactKey);
        return bundleJar;
    }

    public static File getConfigurationFolder(IProfile profile) {
        String config = profile.getProperty("org.eclipse.equinox.p2.configurationFolder");
        if (config != null) {
            return new File(config);
        }
        return new File(Util.getInstallFolder(profile), "configuration");
    }

    public static File getInstallFolder(IProfile profile) {
        String folder = profile.getProperty("org.eclipse.equinox.p2.installFolder");
        return folder == null ? null : new File(folder);
    }

    public static File getLauncherPath(IProfile profile) {
        return new File(Util.getInstallFolder(profile), Util.getLauncherName(profile));
    }

    private static String getLauncherName(IProfile profile) {
        String name = profile.getProperty("eclipse.touchpoint.launcherName");
        String os = Util.getOSFromProfile(profile);
        if (os == null) {
            EnvironmentInfo info;
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
                os = info.getOS();
            }
        }
        if (name == null) {
            name = "eclipse";
        }
        if (os.equals("macosx")) {
            Path path = new Path(name);
            if (path.segment(0).endsWith(".app")) {
                return name;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(name.substring(0, 1).toUpperCase());
            buffer.append(name.substring(1));
            buffer.append(".app/Contents/MacOS/");
            buffer.append(name.toLowerCase());
            return buffer.toString();
        }
        return name;
    }

    private static String getOSFromProfile(IProfile profile) {
        String environments = profile.getProperty("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            int i;
            String entry = tokenizer.nextToken();
            String key = entry.substring(0, i = entry.indexOf(61)).trim();
            if (!key.equals("osgi.os")) continue;
            return entry.substring(i + 1).trim();
        }
        return null;
    }

    public static String getManifest(TouchpointData[] data) {
        int i = 0;
        while (i < data.length) {
            String manifest = data[i].getInstructions("manifest");
            if (manifest != null && manifest.length() > 0) {
                return manifest;
            }
            ++i;
        }
        return null;
    }

    public static String computeRelativeAgentLocation(IProfile profile) {
        URL agentURL = Util.getAgentLocation().getURL();
        Path agentPath = new Path(agentURL.getPath());
        Path configPath = new Path(Util.getConfigurationFolder(profile).getAbsolutePath());
        if (configPath.isPrefixOf((IPath)agentPath)) {
            return "@config.dir/" + agentPath.removeFirstSegments(configPath.segmentCount()).makeRelative().setDevice(null);
        }
        if (agentPath.removeLastSegments(1).equals((Object)configPath.removeLastSegments(1))) {
            return "@config.dir/../" + agentPath.lastSegment();
        }
        return agentURL.toString();
    }

    public static IStatus createError(String message) {
        return Util.createError(message, null);
    }

    public static IStatus createError(String message, Exception e) {
        return new Status(4, "org.eclipse.equinox.p2.touchpoint.eclipse", message, (Throwable)e);
    }

    public static String resolveArtifactParam(Map parameters) throws CoreException {
        IProfile profile = (IProfile)parameters.get("profile");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        IArtifactKey[] artifacts = iu.getArtifacts();
        if (artifacts == null || artifacts.length == 0) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.iu_contains_no_arifacts, (Object)iu)));
        }
        IArtifactKey artifactKey = artifacts[0];
        File fileLocation = Util.getArtifactFile(artifactKey, profile);
        if (fileLocation == null || !fileLocation.exists()) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.artifact_file_not_found, (Object)artifactKey)));
        }
        return fileLocation.getAbsolutePath();
    }

    public static File getLauncherConfigLocation(IProfile profile) {
        String launcherConfig = profile.getProperty("org.eclipse.equinox.p2.launcherConfiguration");
        return launcherConfig == null ? null : new File(launcherConfig);
    }
}

