/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.ui.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.launcher.VMHelper;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractPDELaunchConfiguration
extends LaunchConfigurationDelegate {
    protected File fConfigDir = null;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.fConfigDir = null;
            monitor.beginTask("", 4);
            try {
                this.preLaunchCheck(configuration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() == 8) {
                    monitor.setCanceled(true);
                    return;
                }
                throw e;
            }
            if (configuration.getAttribute("restart", false) && configuration instanceof ILaunchConfigurationWorkingCopy) {
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute("restart", false);
                ((ILaunchConfigurationWorkingCopy)configuration).doSave();
            }
            VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration(this.getMainClass(), this.getClasspath(configuration));
            runnerConfig.setVMArguments(this.getVMArguments(configuration));
            runnerConfig.setProgramArguments(this.getProgramArguments(configuration));
            runnerConfig.setWorkingDirectory(this.getWorkingDirectory(configuration).getAbsolutePath());
            runnerConfig.setEnvironment(this.getEnvironment(configuration));
            runnerConfig.setVMSpecificAttributesMap(this.getVMSpecificAttributesMap(configuration));
            monitor.worked(1);
            this.setDefaultSourceLocator(configuration);
            this.manageLaunch(launch);
            IVMRunner runner = this.getVMRunner(configuration, mode);
            if (runner != null) {
                runner.run(runnerConfig, launch, monitor);
            } else {
                monitor.setCanceled(true);
            }
            monitor.done();
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            LauncherUtils.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)LauncherUtils.getActiveShell(), (String)PDEUIMessages.Launcher_error_title, (String)e.getMessage());
                }
            });
        }
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall launcher = VMHelper.createLauncher(configuration);
        return launcher.getVMRunner(mode);
    }

    protected void setDefaultSourceLocator(ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (!"org.eclipse.pde.ui.workbenchClasspathProvider".equals(id)) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            wc.doSave();
        }
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LaunchArgumentsHelper.constructClasspath(configuration);
        if (classpath == null) {
            String message = PDEUIMessages.WorkbenchLauncherConfigurationDelegate_noStartup;
            throw new CoreException(LauncherUtils.createErrorStatus(message));
        }
        return classpath;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getWorkingDirectory(configuration);
    }

    public Map getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getVMSpecificAttributesMap(configuration);
    }

    public String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] vmArgs = new ExecutionArguments(LaunchArgumentsHelper.getUserVMArguments(configuration), "").getVMArgumentsArray();
        Map bundleMap = LaunchPluginValidator.getPluginsToRun(configuration);
        if (bundleMap.containsKey("org.eclipse.equinox.p2.core")) {
            int i = 0;
            while (i < vmArgs.length) {
                String arg = vmArgs[i];
                if (arg.startsWith("-Declipse.p2.data.area=")) {
                    return vmArgs;
                }
                ++i;
            }
            String[] temp = new String[vmArgs.length + 1];
            System.arraycopy(vmArgs, 0, temp, 0, vmArgs.length);
            temp[vmArgs.length] = "-Declipse.p2.data.area=@config.dir" + File.separator + "p2";
            return temp;
        }
        return vmArgs;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> programArgs = new ArrayList<String>();
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", null))) {
            programArgs.add("-debug");
            programArgs.add(LaunchArgumentsHelper.getTracingFileArgument(configuration, String.valueOf(this.getConfigDir(configuration).toString()) + '/' + ".options"));
        }
        String[] userArgs = LaunchArgumentsHelper.getUserProgramArgumentArray(configuration);
        ArrayList<String> userDefined = new ArrayList<String>();
        int i = 0;
        while (i < userArgs.length) {
            if (!userArgs[i].equals("-debug") || !programArgs.contains("-debug")) {
                userDefined.add(userArgs[i]);
            }
            ++i;
        }
        if (!configuration.getAttribute("append.args", false)) {
            if (!userDefined.contains("-os")) {
                programArgs.add("-os");
                programArgs.add(TargetPlatform.getOS());
            }
            if (!userDefined.contains("-ws")) {
                programArgs.add("-ws");
                programArgs.add(TargetPlatform.getWS());
            }
            if (!userDefined.contains("-arch")) {
                programArgs.add("-arch");
                programArgs.add(TargetPlatform.getOSArch());
            }
        }
        if (userDefined.size() > 0) {
            programArgs.addAll(userDefined);
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean autoValidate = configuration.getAttribute("automaticValidate", false);
        monitor.beginTask("", autoValidate ? 3 : 4);
        if (autoValidate) {
            this.validatePluginDependencies(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        this.validateProjectDependencies(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.clear(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        launch.setAttribute("configLocation", this.getConfigDir(configuration).toString());
        this.synchronizeManifests(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    protected File getConfigDir(ILaunchConfiguration configuration) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea(configuration);
        }
        return this.fConfigDir;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LaunchPluginValidator.getAffectedProjects(configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LaunchPluginValidator.getAffectedProjects(configuration);
    }

    public String getMainClass() {
        if (TargetPlatformHelper.getTargetVersion() >= 3.3) {
            return "org.eclipse.equinox.launcher.Main";
        }
        return "org.eclipse.core.launcher.Main";
    }

    protected void manageLaunch(ILaunch launch) {
        PDEPlugin.getDefault().getLaunchListener().manage(launch);
    }

    protected void synchronizeManifests(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LaunchConfigurationHelper.synchronizeManifests(configuration, this.getConfigDir(configuration));
        monitor.done();
    }

    protected void validateProjectDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LauncherUtils.validateProjectDependencies(configuration, monitor);
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
    }

    protected void validatePluginDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        EclipsePluginValidationOperation op = new EclipsePluginValidationOperation(configuration);
        LaunchPluginValidator.runValidationOperation(op, monitor);
    }
}

