/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.toc;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.toc.TocHTMLWizard;
import org.eclipse.pde.internal.ui.wizards.toc.TocOperation;
import org.eclipse.pde.internal.ui.wizards.toc.TocWizardPage;
import org.eclipse.ui.IWorkbench;

public class NewTocFileWizard
extends TocHTMLWizard {
    private TocWizardPage fPage;
    private IPath fInitialPath = null;

    public void addPages() {
        this.fPage = new TocWizardPage("tocfile", this.getSelection());
        if (this.fInitialPath != null) {
            this.fPage.setContainerFullPath(this.fInitialPath);
        }
        this.addPage((IWizardPage)this.fPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(PDEUIMessages.NewTocFileWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_TARGET_WIZ);
    }

    public boolean performFinish() {
        try {
            this.fNewFile = this.fPage.createNewFile();
            this.getContainer().run(false, true, (IRunnableWithProgress)this.getOperation());
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            this.fNewFile = null;
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.fNewFile = null;
            return false;
        }
        return true;
    }

    private TocOperation getOperation() {
        return new TocOperation(this.fPage.createNewFile(), this.fPage.getTocName());
    }

    public void setInitialPath(IPath path) {
        this.fInitialPath = path;
    }
}

