/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.provisioner.update;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.provisioner.update.IUpdateSiteProvisionerEntry;
import org.eclipse.pde.internal.ui.wizards.provisioner.update.UpdateSiteProvisionerPage;
import org.eclipse.pde.ui.IProvisionerWizard;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.OperationsManager;

public class UpdateSiteProvisionerWizard
extends Wizard
implements IProvisionerWizard {
    private File[] fDirs = null;
    private UpdateSiteProvisionerPage fPage;

    public UpdateSiteProvisionerWizard() {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEUIMessages.UpdateSiteProvisionerWizard_title);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWSITEPRJ_WIZ);
    }

    public void addPages() {
        this.fPage = new UpdateSiteProvisionerPage("update site");
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        ArrayList<File> dirs = new ArrayList<File>();
        try {
            IUpdateSiteProvisionerEntry[] entries = this.fPage.getEntries();
            this.getContainer().run(false, false, (IRunnableWithProgress)new UpdateSiteDownloader(entries));
            int i = 0;
            while (i < entries.length) {
                IUpdateSiteProvisionerEntry entry = entries[i];
                File file = new File(entry.getInstallLocation(), "eclipse");
                if (file.exists()) {
                    dirs.add(file);
                }
                ++i;
            }
            this.fDirs = dirs.toArray(new File[dirs.size()]);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public File[] getLocations() {
        return this.fDirs;
    }

    class UpdateSiteDownloader
    implements IRunnableWithProgress,
    IOperationListener {
        private IUpdateSiteProvisionerEntry[] entries;

        public UpdateSiteDownloader(IUpdateSiteProvisionerEntry[] entries) {
            this.entries = entries;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    monitor.beginTask(PDEUIMessages.UpdateSiteDownloader_message, this.entries.length);
                    int i = 0;
                    while (i < this.entries.length) {
                        IUpdateSiteProvisionerEntry entry = this.entries[i];
                        File sitePath = new File(entry.getInstallLocation());
                        URL remoteSiteURL = new URL(entry.getSiteLocation());
                        ISite site = SiteManager.getSite((URL)sitePath.toURL(), null);
                        IConfiguredSite csite = site.getCurrentConfiguredSite();
                        if (csite == null) {
                            ILocalSite localSite = SiteManager.getLocalSite();
                            IInstallConfiguration config = localSite.getCurrentConfiguration();
                            csite = config.createConfiguredSite(sitePath);
                            csite.verifyUpdatableStatus();
                        }
                        ISite remoteSite = SiteManager.getSite((URL)remoteSiteURL, null);
                        ISiteFeatureReference[] references = remoteSite.getFeatureReferences();
                        int j = 0;
                        while (j < references.length) {
                            ISiteFeatureReference reference = references[j];
                            IFeature feature = reference.getFeature(null);
                            IInstallFeatureOperation operation = OperationsManager.getOperationFactory().createInstallOperation(csite, feature, null, null, null);
                            operation.execute(monitor, (IOperationListener)this);
                            ++j;
                        }
                        monitor.worked(1);
                        ++i;
                    }
                }
                catch (MalformedURLException e) {
                    PDEPlugin.log(e);
                    monitor.done();
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        public boolean afterExecute(IOperation operation, Object data) {
            return true;
        }

        public boolean beforeExecute(IOperation operation, Object data) {
            return true;
        }
    }
}

