/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.provisioner;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.provisioner.ProvisionerListSelectionPage;
import org.eclipse.pde.ui.IProvisionerWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class AddTargetPluginsWizard
extends NewWizard {
    private static final String PROVISIONER_POINT = "targetProvisioners";
    private ProvisionerListSelectionPage fSelectionPage = null;
    private File[] fDirs = null;
    private IProvisionerWizard fWizard = null;

    public AddTargetPluginsWizard() {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEUIMessages.AddTargetPluginsWizard_windowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setForcePreviousAndNextButtons(true);
        ElementList list = this.getAvailableProvisioners();
        if (list.size() == 1) {
            try {
                this.fWizard = (IProvisionerWizard)((WizardElement)list.getChildren()[0]).createExecutableExtension();
            }
            catch (CoreException coreException) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.Errors_CreationError, (String)PDEUIMessages.Errors_CreationError_NoWizard);
            }
            this.fWizard.addPages();
            IWizardPage[] pages = this.fWizard.getPages();
            int i = 0;
            while (i < pages.length) {
                this.addPage(pages[i]);
                ++i;
            }
        } else {
            this.fSelectionPage = new ProvisionerListSelectionPage(this.getAvailableProvisioners());
            this.addPage((IWizardPage)this.fSelectionPage);
        }
        super.addPages();
    }

    private ElementList getAvailableProvisioners() {
        ElementList list = new ElementList(PROVISIONER_POINT);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PDEPlugin.getPluginId(), PROVISIONER_POINT);
        if (point == null) {
            return list;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                WizardElement element = this.createWizardElement(elements[j]);
                if (element != null) {
                    final String pluginId = element.getPluginId();
                    final String contributionId = element.getID();
                    IPluginContribution pc = new IPluginContribution(){

                        public String getLocalId() {
                            return contributionId;
                        }

                        public String getPluginId() {
                            return pluginId;
                        }
                    };
                    if (!WorkbenchActivityHelper.filterItem((Object)pc)) {
                        list.add(element);
                    }
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        if (name == null || id == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        Image image = null;
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
        }
        element.setImage(image);
        return element;
    }

    public boolean canFinish() {
        return (this.fSelectionPage != null && this.getPageCount() > 1 || this.fSelectionPage == null) && super.canFinish();
    }

    public boolean performFinish() {
        IProvisionerWizard wizard;
        IProvisionerWizard iProvisionerWizard = wizard = this.fSelectionPage != null ? (IProvisionerWizard)this.fSelectionPage.getSelectedWizard() : this.fWizard;
        if (wizard == null) {
            return true;
        }
        this.fDirs = wizard.getLocations();
        return super.performFinish();
    }

    public File[] getDirectories() {
        return this.fDirs == null ? new File[]{} : this.fDirs;
    }
}

