/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.PDEWizardNewFileCreationPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ProductFileWizardPage
extends PDEWizardNewFileCreationPage {
    public static final int USE_DEFAULT = 0;
    public static final int USE_PRODUCT = 1;
    public static final int USE_LAUNCH_CONFIG = 2;
    private static final String F_FILE_EXTENSION = "product";
    private Button fBasicButton;
    private Button fProductButton;
    private Combo fProductCombo;
    private Button fLaunchConfigButton;
    private Combo fLaunchConfigCombo;
    private Group fGroup;
    private IPluginModelBase fModel;
    static /* synthetic */ Class class$0;

    public ProductFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setDescription(PDEUIMessages.ProductFileWizadPage_title);
        this.setTitle(PDEUIMessages.NewProductFileWizard_title);
        this.setFileExtension(F_FILE_EXTENSION);
        this.initializeModel(selection);
    }

    private void initializeModel(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selected instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)selected;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                IProject project = resource.getProject();
                this.fModel = PluginRegistry.findModel((IProject)project);
            }
        }
    }

    protected void createAdvancedControls(Composite parent) {
        this.fGroup = new Group(parent, 0);
        this.fGroup.setText(PDEUIMessages.ProductFileWizadPage_groupTitle);
        this.fGroup.setLayout((Layout)new GridLayout(2, false));
        this.fGroup.setLayoutData((Object)new GridData(768));
        this.fBasicButton = new Button((Composite)this.fGroup, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fBasicButton.setLayoutData((Object)gd);
        this.fBasicButton.setText(PDEUIMessages.ProductFileWizadPage_basic);
        this.fProductButton = new Button((Composite)this.fGroup, 16);
        this.fProductButton.setText(PDEUIMessages.ProductFileWizadPage_existingProduct);
        this.fProductButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductFileWizardPage.this.fProductCombo.setEnabled(ProductFileWizardPage.this.fProductButton.getSelection());
            }
        });
        this.fProductCombo = new Combo((Composite)this.fGroup, 12);
        this.fProductCombo.setLayoutData((Object)new GridData(768));
        this.fProductCombo.setItems(TargetPlatform.getProducts());
        this.fLaunchConfigButton = new Button((Composite)this.fGroup, 16);
        this.fLaunchConfigButton.setText(PDEUIMessages.ProductFileWizadPage_existingLaunchConfig);
        this.fLaunchConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductFileWizardPage.this.fLaunchConfigCombo.setEnabled(ProductFileWizardPage.this.fLaunchConfigButton.getSelection());
            }
        });
        this.fLaunchConfigCombo = new Combo((Composite)this.fGroup, 12);
        this.fLaunchConfigCombo.setLayoutData((Object)new GridData(768));
        this.fLaunchConfigCombo.setItems(this.getLaunchConfigurations());
        this.initializeState();
    }

    private void initializeState() {
        this.fLaunchConfigCombo.setEnabled(false);
        if (this.fLaunchConfigCombo.getItemCount() > 0) {
            this.fLaunchConfigCombo.setText(this.fLaunchConfigCombo.getItem(0));
        }
        if (this.fModel != null && this.fModel.getPluginBase().getId() != null) {
            IPluginExtension[] extensions = this.fModel.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                String full;
                String id;
                String point = extensions[i].getPoint();
                if ("org.eclipse.core.runtime.products".equals(point) && (id = extensions[i].getId()) != null && this.fProductCombo.indexOf(full = String.valueOf(this.fModel.getPluginBase().getId()) + "." + id) != -1) {
                    this.fProductCombo.setText(full);
                    this.fProductButton.setSelection(true);
                    return;
                }
                ++i;
            }
        }
        this.fBasicButton.setSelection(true);
        this.fProductCombo.setEnabled(false);
        if (this.fProductCombo.getItemCount() > 0) {
            this.fProductCombo.setText(this.fProductCombo.getItem(0));
        }
    }

    private String[] getLaunchConfigurations() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
            int i = 0;
            while (i < configs.length) {
                if (!DebugUITools.isPrivate((ILaunchConfiguration)configs[i])) {
                    list.add(configs[i].getName());
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return list.toArray(new String[list.size()]);
    }

    public ILaunchConfiguration getSelectedLaunchConfiguration() {
        if (!this.fLaunchConfigButton.getSelection()) {
            return null;
        }
        String configName = this.fLaunchConfigCombo.getText();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
            int i = 0;
            while (i < configs.length) {
                if (configs[i].getName().equals(configName) && !DebugUITools.isPrivate((ILaunchConfiguration)configs[i])) {
                    return configs[i];
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public String getSelectedProduct() {
        return this.fProductButton.getSelection() ? this.fProductCombo.getText() : null;
    }

    public int getInitializationOption() {
        if (this.fBasicButton.getSelection()) {
            return 0;
        }
        if (this.fProductButton.getSelection()) {
            return 1;
        }
        return 2;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.fGroup);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.product_file_page");
    }
}

