/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.TemplateListSelectionPage;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewPluginProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String PLUGIN_POINT = "pluginContent";
    public static final String TAG_WIZARD = "wizard";
    public static final String DEF_PROJECT_NAME = "project_name";
    public static final String DEF_TEMPLATE_ID = "template-id";
    private IConfigurationElement fConfig;
    private PluginFieldData fPluginData;
    private IProjectProvider fProjectProvider;
    private NewProjectCreationPage fMainPage;
    private PluginContentPage fContentPage;
    private TemplateListSelectionPage fWizardListPage;
    private boolean fPureOSGi;

    public NewPluginProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEUIMessages.NewProjectWizard_title);
        this.setNeedsProgressMonitor(true);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fPluginData = new PluginFieldData();
    }

    public NewPluginProjectWizard(String osgiFramework) {
        this();
        this.fPluginData.setOSGiFramework(osgiFramework);
    }

    public void addPages() {
        this.fMainPage = new NewProjectCreationPage("main", this.fPluginData, this.fPureOSGi, this.getSelection());
        this.fMainPage.setTitle(PDEUIMessages.NewProjectWizard_MainPage_title);
        this.fMainPage.setDescription(PDEUIMessages.NewProjectWizard_MainPage_desc);
        String pname = this.getDefaultValue(DEF_PROJECT_NAME);
        if (pname != null) {
            this.fMainPage.setInitialProjectName(pname);
        }
        this.addPage((IWizardPage)this.fMainPage);
        this.fProjectProvider = new IProjectProvider(){

            public String getProjectName() {
                return NewPluginProjectWizard.this.fMainPage.getProjectName();
            }

            public IProject getProject() {
                return NewPluginProjectWizard.this.fMainPage.getProjectHandle();
            }

            public IPath getLocationPath() {
                return NewPluginProjectWizard.this.fMainPage.getLocationPath();
            }
        };
        this.fContentPage = new PluginContentPage("page2", this.fProjectProvider, this.fMainPage, this.fPluginData);
        this.fWizardListPage = new TemplateListSelectionPage(this.getAvailableCodegenWizards(), this.fContentPage, PDEUIMessages.WizardListSelectionPage_templates);
        String tid = this.getDefaultValue(DEF_TEMPLATE_ID);
        if (tid != null) {
            this.fWizardListPage.setInitialTemplateId(tid);
        }
        this.addPage((IWizardPage)this.fContentPage);
        this.addPage((IWizardPage)this.fWizardListPage);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return super.canFinish() && page != this.fMainPage;
    }

    public boolean performFinish() {
        try {
            this.fMainPage.updateData();
            this.fContentPage.updateData();
            IDialogSettings settings = this.getDialogSettings();
            if (settings != null) {
                this.fMainPage.saveSettings(settings);
                this.fContentPage.saveSettings(settings);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            IPluginContentWizard contentWizard = this.fWizardListPage.getSelectedWizard();
            this.getContainer().run(false, true, (IRunnableWithProgress)new NewProjectCreationOperation(this.fPluginData, this.fProjectProvider, contentWizard));
            this.addApiAnalysisNature(this.fContentPage.setupApiAnalysis());
            IWorkingSet[] workingSets = this.fMainPage.getSelectedWorkingSets();
            this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)this.fProjectProvider.getProject(), workingSets);
            return true;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private void addApiAnalysisNature(boolean add) {
        try {
            IProject project = this.fProjectProvider.getProject();
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.pde.api.tools.apiAnalysisNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfig = config;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        String className = config.getAttribute("class");
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
            element.setImage(image);
        }
        return element;
    }

    public ElementList getAvailableCodegenWizards() {
        ElementList wizards = new ElementList("CodegenWizards");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PDEPlugin.getPluginId(), PLUGIN_POINT);
        if (point == null) {
            return wizards;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                WizardElement element;
                if (elements[j].getName().equals(TAG_WIZARD) && (element = this.createWizardElement(elements[j])) != null) {
                    wizards.add(element);
                }
                ++j;
            }
            ++i;
        }
        return wizards;
    }

    public String getPluginId() {
        return this.fPluginData.getId();
    }
}

