/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.PDELabelUtility;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class ContentPage
extends WizardPage {
    protected boolean fInitialized = false;
    protected Text fIdText;
    protected Text fVersionText;
    protected Text fNameText;
    protected Text fProviderText;
    protected NewProjectCreationPage fMainPage;
    protected AbstractFieldData fData;
    protected IProjectProvider fProjectProvider;
    protected static final int PROPERTIES_GROUP = 1;
    protected int fChangedGroups = 0;
    protected ModifyListener propertiesListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ContentPage.this.fInitialized) {
                ContentPage.this.fChangedGroups |= 1;
            }
            ContentPage.this.validatePage();
        }
    };

    public ContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName);
        this.fMainPage = page;
        this.fProjectProvider = provider;
        this.fData = data;
    }

    protected Text createText(Composite parent, ModifyListener listener) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(listener);
        return text;
    }

    protected Text createText(Composite parent, ModifyListener listener, int horizSpan) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.horizontalSpan = horizSpan;
        text.setLayoutData((Object)data);
        text.addModifyListener(listener);
        return text;
    }

    protected abstract void validatePage();

    protected String validateProperties() {
        if (!this.fInitialized) {
            if (!this.fIdText.getText().trim().equals(this.fProjectProvider.getProjectName())) {
                this.setMessage(PDEUIMessages.ContentPage_illegalCharactersInID, 1);
            } else {
                this.setMessage(null);
            }
            return null;
        }
        this.setMessage(null);
        String errorMessage = null;
        errorMessage = this.validateId();
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = this.validateVersion(this.fVersionText);
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = this.validateName();
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    protected String validateVersion(Text text) {
        if (text.getText().trim().length() == 0) {
            return PDELabelUtility.qualifyMessage(PDELabelUtility.getFieldLabel((Control)text), PDEUIMessages.ControlValidationUtility_errorMsgValueMustBeSpecified);
        }
        if (!this.isVersionValid(text.getText().trim())) {
            return PDELabelUtility.qualifyMessage(PDELabelUtility.getFieldLabel((Control)text), PDECoreMessages.BundleErrorReporter_InvalidFormatInBundleVersion);
        }
        return null;
    }

    private String validateName() {
        if (this.fNameText.getText().trim().length() == 0) {
            return PDEUIMessages.ContentPage_noname;
        }
        return null;
    }

    private String validateId() {
        String id = this.fIdText.getText().trim();
        if (id.length() == 0) {
            return PDEUIMessages.ContentPage_noid;
        }
        if (!IdUtil.isValidCompositeID((String)id)) {
            return PDEUIMessages.ContentPage_invalidId;
        }
        return null;
    }

    protected boolean isVersionValid(String version) {
        return VersionUtil.validateVersion((String)version).getSeverity() == 0;
    }

    public IWizardPage getNextPage() {
        this.updateData();
        return super.getNextPage();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            String id = this.computeId();
            if ((this.fChangedGroups & 1) == 0) {
                int oldfChanged = this.fChangedGroups;
                this.fIdText.setText(id);
                this.fVersionText.setText("1.0.0");
                this.fNameText.setText(IdUtil.getValidName((String)id, (String)this.getNameFieldQualifier()));
                this.fProviderText.setText(IdUtil.getValidProvider((String)id));
                this.fChangedGroups = oldfChanged;
            }
            if (this.fInitialized) {
                this.validatePage();
            } else {
                this.fInitialized = true;
            }
        }
        super.setVisible(visible);
    }

    protected String computeId() {
        return IdUtil.getValidId((String)this.fProjectProvider.getProjectName());
    }

    protected abstract String getNameFieldQualifier();

    public void updateData() {
        this.fData.setId(this.fIdText.getText().trim());
        this.fData.setVersion(this.fVersionText.getText().trim());
        this.fData.setName(this.fNameText.getText().trim());
        this.fData.setProvider(this.fProviderText.getText().trim());
    }

    public IFieldData getData() {
        return this.fData;
    }

    public String getId() {
        return this.fIdText.getText().trim();
    }
}

