/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportTab;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExportOptionsTab
extends AbstractExportTab {
    protected static final String S_JAR_FORMAT = "exportUpdate";
    private static final String S_EXPORT_SOURCE = "exportSource";
    private static final String S_SAVE_AS_ANT = "saveAsAnt";
    private static final String S_ANT_FILENAME = "antFileName";
    private static final String S_QUALIFIER = "qualifier";
    private static final String S_QUALIFIER_NAME = "qualifierName";
    private Button fIncludeSource;
    protected Button fJarButton;
    private Button fSaveAsAntButton;
    private Combo fAntCombo;
    private Button fBrowseAnt;
    private Button fQualifierButton;
    private Text fQualifierText;

    public ExportOptionsTab(BaseExportWizardPage page) {
        super(page);
    }

    protected Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(768));
        this.addSourceOption(container);
        this.addJAROption(container);
        this.addCrossPlatformOption(container);
        this.addQualifierOption(container);
        this.addAntSection(container);
        return container;
    }

    protected void addSourceOption(Composite comp) {
        this.fIncludeSource = new Button(comp, 32);
        this.fIncludeSource.setText(PDEUIMessages.ExportWizard_includeSource);
    }

    protected void addJAROption(Composite comp) {
        this.fJarButton = new Button(comp, 32);
        this.fJarButton.setText(this.getJarButtonText());
        this.fJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
    }

    protected String getJarButtonText() {
        return PDEUIMessages.BaseExportWizardPage_packageJARs;
    }

    protected void addCrossPlatformOption(Composite comp) {
    }

    protected void addAntSection(Composite container) {
        Composite comp = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fSaveAsAntButton = new Button(comp, 32);
        this.fSaveAsAntButton.setText(PDEUIMessages.ExportWizard_antCheck);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.fSaveAsAntButton.setLayoutData((Object)gd);
        this.fAntCombo = new Combo(comp, 0);
        this.fAntCombo.setLayoutData((Object)new GridData(768));
        this.fBrowseAnt = new Button(comp, 8);
        this.fBrowseAnt.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseAnt.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseAnt);
    }

    protected void addQualifierOption(Composite container) {
        Composite comp = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fQualifierButton = new Button(comp, 32);
        this.fQualifierButton.setText(PDEUIMessages.AdvancedPluginExportPage_qualifier);
        this.fQualifierText = new Text(comp, 2052);
        this.fQualifierText.setLayoutData((Object)new GridData(768));
        this.fQualifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportOptionsTab.this.fPage.pageChanged();
            }
        });
    }

    protected void initialize(IDialogSettings settings) {
        this.fIncludeSource.setSelection(settings.getBoolean(S_EXPORT_SOURCE));
        this.fJarButton.setSelection(this.getInitialJarButtonSelection(settings));
        this.fSaveAsAntButton.setSelection(settings.getBoolean(S_SAVE_AS_ANT));
        this.initializeCombo(settings, S_ANT_FILENAME, this.fAntCombo);
        this.fAntCombo.setEnabled(this.fSaveAsAntButton.getSelection());
        this.fBrowseAnt.setEnabled(this.fSaveAsAntButton.getSelection());
        this.fQualifierButton.setSelection(settings.getBoolean(S_QUALIFIER));
        this.fQualifierText.setText(this.getInitialQualifierText(settings));
        this.fQualifierText.setEnabled(this.fQualifierButton.getSelection());
        this.hookListeners();
    }

    protected void saveSettings(IDialogSettings settings) {
        settings.put(S_JAR_FORMAT, this.fJarButton.getSelection());
        settings.put(S_EXPORT_SOURCE, this.fIncludeSource.getSelection());
        settings.put(S_SAVE_AS_ANT, this.fSaveAsAntButton.getSelection());
        settings.put(S_QUALIFIER, this.fQualifierButton.getSelection());
        settings.put(S_QUALIFIER_NAME, this.fQualifierText.getText());
        this.saveCombo(settings, S_ANT_FILENAME, this.fAntCombo);
    }

    private String getInitialQualifierText(IDialogSettings settings) {
        String qualifier = settings.get(S_QUALIFIER_NAME);
        if (qualifier == null || qualifier.equals("")) {
            return FeatureExportOperation.getDate();
        }
        return qualifier;
    }

    protected boolean getInitialJarButtonSelection(IDialogSettings settings) {
        String selected = settings.get(S_JAR_FORMAT);
        return selected == null ? TargetPlatformHelper.getTargetVersion() >= 3.1 : "true".equals(selected);
    }

    protected void hookListeners() {
        this.fJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((BaseExportWizardPage)ExportOptionsTab.this.fPage).adjustAdvancedTabsVisibility();
            }
        });
        this.fSaveAsAntButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportOptionsTab.this.fAntCombo.setEnabled(ExportOptionsTab.this.fSaveAsAntButton.getSelection());
                ExportOptionsTab.this.fBrowseAnt.setEnabled(ExportOptionsTab.this.fSaveAsAntButton.getSelection());
                ExportOptionsTab.this.fPage.pageChanged();
            }
        });
        this.fBrowseAnt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportOptionsTab.this.chooseFile(ExportOptionsTab.this.fAntCombo, "*.xml");
            }
        });
        this.fAntCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportOptionsTab.this.fPage.pageChanged();
            }
        });
        this.fAntCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportOptionsTab.this.fPage.pageChanged();
            }
        });
        this.fQualifierButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportOptionsTab.this.fQualifierText.setEnabled(ExportOptionsTab.this.fQualifierButton.getSelection());
                ExportOptionsTab.this.fPage.pageChanged();
            }
        });
    }

    protected String validate() {
        if (this.fSaveAsAntButton.getSelection() && this.fAntCombo.getText().trim().length() == 0) {
            return PDEUIMessages.ExportWizard_status_noantfile;
        }
        return null;
    }

    protected String validateAntCombo() {
        String path = new Path(this.fAntCombo.getText()).lastSegment();
        if ("build.xml".equals(path)) {
            return PDEUIMessages.ExportOptionsTab_antReservedMessage;
        }
        return null;
    }

    protected boolean doExportSource() {
        return this.fIncludeSource.getSelection();
    }

    protected boolean useJARFormat() {
        return this.fJarButton.getSelection();
    }

    protected boolean doGenerateAntFile() {
        return this.fSaveAsAntButton.getSelection();
    }

    protected String getAntBuildFileName() {
        return this.fSaveAsAntButton.getSelection() ? this.fAntCombo.getText() : null;
    }

    protected String getQualifier() {
        String qualifier;
        if (this.fQualifierText.isEnabled() && (qualifier = this.fQualifierText.getText().trim()).length() > 0) {
            return qualifier;
        }
        return null;
    }
}

