/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public abstract class AntGeneratingExportWizard
extends BaseExportWizard {
    protected BaseExportWizardPage fPage;

    public void addPages() {
        this.fPage = this.createPage1();
        this.addPage((IWizardPage)this.fPage);
    }

    protected abstract BaseExportWizardPage createPage1();

    protected boolean performPreliminaryChecks() {
        if (this.fPage.doGenerateAntFile()) {
            this.generateAntBuildFile(this.fPage.getAntBuildFileName());
        }
        return true;
    }

    protected boolean confirmDelete() {
        File zipFile;
        if (!this.fPage.doExportToDirectory() && (zipFile = new File(this.fPage.getDestination(), this.fPage.getFileName())).exists()) {
            if (!MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)PDEUIMessages.BaseExportWizard_confirmReplace_title, (String)NLS.bind((String)PDEUIMessages.BaseExportWizard_confirmReplace_desc, (Object)zipFile.getAbsolutePath()))) {
                return false;
            }
            zipFile.delete();
        }
        return true;
    }

    protected abstract Document generateAntTask();

    protected void generateAntBuildFile(String filename) {
        File dir;
        String parent = new Path(filename).removeLastSegments(1).toOSString();
        String buildFilename = new Path(filename).lastSegment();
        if (!buildFilename.endsWith(".xml")) {
            buildFilename = String.valueOf(buildFilename) + ".xml";
        }
        if (!(dir = new File(new File(parent).getAbsolutePath())).exists()) {
            dir.mkdirs();
        }
        try {
            Document task = this.generateAntTask();
            if (task != null) {
                File buildFile = new File(dir, buildFilename);
                XMLPrintHandler.writeFile((Document)task, (File)buildFile);
                this.generateAntTask();
                this.setDefaultValues(dir, buildFilename);
            }
        }
        catch (IOException iOException) {}
    }

    private void setDefaultValues(File dir, String buildFilename) {
        try {
            IProject project;
            IContainer container = PDEPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(dir.toString()));
            if (container != null && container.exists() && (project = container.getProject()) != null) {
                project.refreshLocal(2, null);
                IFile file = container.getFile((IPath)new Path(buildFilename));
                if (file.exists()) {
                    BaseBuildAction.setDefaultValues(file);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected String getExportOperation() {
        return this.fPage.doExportToDirectory() ? "directory" : "zip";
    }
}

