/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.cheatsheet;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.CSFileWizardPage;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.CompCSCreationOperation;
import org.eclipse.pde.internal.ui.wizards.cheatsheet.SimpleCSCreationOperation;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class NewCSFileWizard
extends BasicNewFileResourceWizard
implements INewWizard {
    protected CSFileWizardPage fMainPage;

    public void addPages() {
        this.fMainPage = new CSFileWizardPage("cheatsheet", this.getSelection());
        this.addPage((IWizardPage)this.fMainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(PDEUIMessages.NewCheatSheetFileWizard_0);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_CHEATSHEET_WIZ);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, this.getOperation());
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private IRunnableWithProgress getOperation() {
        IFile file = this.fMainPage.createNewFile();
        int option = this.fMainPage.getCheatSheetType();
        if (option == 0) {
            return new SimpleCSCreationOperation(file);
        }
        if (option == 1) {
            return new CompCSCreationOperation(file);
        }
        PDEPlugin.logErrorMessage("Unknown cheat sheet type encountered");
        return null;
    }
}

