/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class OSGiFrameworkPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer fTableViewer;
    private Button fSetDefaultButton;
    private String fDefaultFramework;

    public OSGiFrameworkPreferencePage() {
        this.setDefaultFramework();
    }

    private void setDefaultFramework() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        this.fDefaultFramework = store.getString("Preference.default.osgi.framework");
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Link text = new Link(container, 64);
        text.setText(PDEUIMessages.OSGiFrameworkPreferencePage_installed);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPluginExtensionPoint point = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint("org.eclipse.pde.ui.osgiFrameworks");
                if (point != null) {
                    new ShowDescriptionAction(point, true).run();
                } else {
                    Display.getDefault().beep();
                }
            }
        });
        this.fTableViewer = new TableViewer(container, 2048);
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FrameworkLabelProvider());
        this.fTableViewer.setInput((Object)PDEPlugin.getDefault().getOSGiFrameworkManager().getSortedFrameworks());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                String id = ((IConfigurationElement)ssel.getFirstElement()).getAttribute("id");
                OSGiFrameworkPreferencePage.this.fSetDefaultButton.setEnabled(ssel.size() == 1 && !OSGiFrameworkPreferencePage.this.fDefaultFramework.equals(id));
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        this.fSetDefaultButton = new Button(buttonContainer, 8);
        this.fSetDefaultButton.setText(PDEUIMessages.OSGiFrameworkPreferencePage_setAs);
        this.fSetDefaultButton.setLayoutData((Object)new GridData(6));
        SWTUtil.setButtonDimensionHint(this.fSetDefaultButton);
        this.fSetDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)OSGiFrameworkPreferencePage.this.fTableViewer.getSelection();
                IConfigurationElement element = (IConfigurationElement)ssel.getFirstElement();
                OSGiFrameworkPreferencePage.this.fDefaultFramework = element.getAttribute("id");
                OSGiFrameworkPreferencePage.this.fTableViewer.refresh();
                OSGiFrameworkPreferencePage.this.fSetDefaultButton.setEnabled(false);
            }
        });
        this.fSetDefaultButton.setEnabled(false);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.osgi_preference_page");
        return container;
    }

    public boolean performOk() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        store.setValue("Preference.default.osgi.framework", this.fDefaultFramework);
        PDEPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        this.setDefaultFramework();
        this.fTableViewer.refresh();
    }

    public void init(IWorkbench workbench) {
    }

    class FrameworkLabelProvider
    extends LabelProvider {
        FrameworkLabelProvider() {
        }

        public Image getImage(Object element) {
            return PDEPluginImages.get(PDEPluginImages.OBJ_DESC_BUNDLE);
        }

        public String getText(Object element) {
            if (element instanceof IConfigurationElement) {
                String name = ((IConfigurationElement)element).getAttribute("name");
                String id = ((IConfigurationElement)element).getAttribute("id");
                return OSGiFrameworkPreferencePage.this.fDefaultFramework.equals(id) ? String.valueOf(name) + " " + PDEUIMessages.OSGiFrameworkPreferencePage_default : name;
            }
            return super.getText(element);
        }
    }
}

