/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.internal.ui.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.launcher.OSGiValidationOperation;
import org.eclipse.pde.ui.launcher.BundlesTab;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class OSGiBundleBlock
extends AbstractPluginBlock {
    private HashMap levelColumnCache = new HashMap();
    private HashMap autoColumnCache = new HashMap();
    private TreeEditor levelColumnEditor = null;
    private TreeEditor autoColumnEditor = null;
    private ILaunchConfiguration fLaunchConfiguration;

    public OSGiBundleBlock(BundlesTab tab) {
        super(tab);
    }

    protected void createPluginViewer(Composite composite, int span, int indent) {
        super.createPluginViewer(composite, span, indent);
        Tree tree = this.fPluginTreeViewer.getTree();
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText(this.fTab.getName());
        column1.setWidth(300);
        TreeColumn column2 = new TreeColumn(tree, 0x1000000);
        column2.setText(PDEUIMessages.EquinoxPluginBlock_levelColumn);
        column2.setWidth(80);
        TreeColumn column3 = new TreeColumn(tree, 0x1000000);
        column3.setText(PDEUIMessages.EquinoxPluginBlock_autoColumn);
        column3.setWidth(80);
        tree.setHeaderVisible(true);
        this.createEditors();
    }

    private void createEditors() {
        final Tree tree = this.fPluginTreeViewer.getTree();
        this.levelColumnEditor = new TreeEditor(tree);
        this.levelColumnEditor.horizontalAlignment = 0x1000000;
        this.levelColumnEditor.minimumWidth = 60;
        this.autoColumnEditor = new TreeEditor(tree);
        this.autoColumnEditor.horizontalAlignment = 0x1000000;
        this.autoColumnEditor.grabHorizontal = true;
        this.autoColumnEditor.minimumWidth = 60;
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                Control oldEditor = OSGiBundleBlock.this.levelColumnEditor.getEditor();
                if (oldEditor != null && !oldEditor.isDisposed()) {
                    oldEditor.dispose();
                }
                if ((oldEditor = OSGiBundleBlock.this.autoColumnEditor.getEditor()) != null && !oldEditor.isDisposed()) {
                    oldEditor.dispose();
                }
                if (!OSGiBundleBlock.this.isEditable(item = (TreeItem)e.item)) {
                    return;
                }
                if (!OSGiBundleBlock.this.isFragment(item)) {
                    Spinner spinner = new Spinner((Composite)tree, 2048);
                    spinner.setMinimum(0);
                    String level = item.getText(1);
                    int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
                    spinner.setSelection(defaultLevel);
                    spinner.addModifyListener(new ModifyListener(this, item, spinner){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ TreeItem val$item;
                        private final /* synthetic */ Spinner val$spinner;
                        {
                            this.this$1 = var1_1;
                            this.val$item = treeItem;
                            this.val$spinner = spinner;
                        }

                        public void modifyText(ModifyEvent e) {
                            if (this.val$item.getChecked()) {
                                int selection = this.val$spinner.getSelection();
                                this.val$item.setText(1, selection == 0 ? "default" : Integer.toString(selection));
                                OSGiBundleBlock.access$0(1.access$0(this.this$1)).put(this.val$item.getData(), this.val$item.getText(1));
                                1.access$0(this.this$1).fTab.updateLaunchConfigurationDialog();
                            }
                        }
                    });
                    OSGiBundleBlock.this.levelColumnEditor.setEditor((Control)spinner, item, 1);
                    CCombo combo = new CCombo((Composite)tree, 2056);
                    combo.setItems(new String[]{"default", Boolean.toString(true), Boolean.toString(false)});
                    combo.setText(item.getText(2));
                    combo.pack();
                    combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, item, combo){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ TreeItem val$item;
                        private final /* synthetic */ CCombo val$combo;
                        {
                            this.this$1 = var1_1;
                            this.val$item = treeItem;
                            this.val$combo = cCombo;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            if (this.val$item.getChecked()) {
                                this.val$item.setText(2, this.val$combo.getText());
                                OSGiBundleBlock.access$1(1.access$0(this.this$1)).put(this.val$item.getData(), this.val$item.getText(2));
                                1.access$0(this.this$1).fTab.updateLaunchConfigurationDialog();
                            }
                        }
                    });
                    OSGiBundleBlock.this.autoColumnEditor.setEditor((Control)combo, item, 2);
                }
            }

            static /* synthetic */ OSGiBundleBlock access$0(1 var0) {
                return var0.OSGiBundleBlock.this;
            }
        });
    }

    private boolean isEditable(TreeItem item) {
        Object obj = item.getData();
        if (obj instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)obj;
            String systemBundleId = PDECore.getDefault().getModelManager().getSystemBundleId();
            if (!systemBundleId.equals(model.getPluginBase().getId())) {
                return this.fPluginTreeViewer.getChecked((Object)model);
            }
        }
        return false;
    }

    private boolean isFragment(TreeItem item) {
        Object obj = item.getData();
        if (obj instanceof IPluginModelBase) {
            return ((IPluginModelBase)obj).isFragmentModel();
        }
        return false;
    }

    protected ILabelProvider getLabelProvider() {
        return new OSGiLabelProvider();
    }

    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        Object[] selected = this.fPluginTreeViewer.getCheckedElements();
        StringBuffer wBuffer = new StringBuffer();
        StringBuffer tBuffer = new StringBuffer();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)selected[i];
                if (model.getUnderlyingResource() == null) {
                    this.appendToBuffer(tBuffer, model);
                } else {
                    this.appendToBuffer(wBuffer, model);
                }
            }
            ++i;
        }
        config.setAttribute("workspace_bundles", wBuffer.length() == 0 ? null : wBuffer.toString());
        config.setAttribute("target_bundles", tBuffer.length() == 0 ? null : tBuffer.toString());
        StringBuffer buffer = new StringBuffer();
        if (this.fAddWorkspaceButton.getSelection()) {
            int i2 = 0;
            while (i2 < this.fWorkspaceModels.length) {
                if (!this.fPluginTreeViewer.getChecked((Object)this.fWorkspaceModels[i2])) {
                    this.appendToBuffer(buffer, this.fWorkspaceModels[i2]);
                }
                ++i2;
            }
        }
        config.setAttribute("deselected_workspace_plugins", buffer.length() > 0 ? buffer.toString() : null);
    }

    private void appendToBuffer(StringBuffer buffer, IPluginModelBase model) {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        String startLevel = null;
        String autoStart = null;
        if (this.fPluginTreeViewer.getChecked((Object)model)) {
            startLevel = this.levelColumnCache.get(model) != null ? this.levelColumnCache.get(model).toString() : null;
            autoStart = this.autoColumnCache.get(model) != null ? this.autoColumnCache.get(model).toString() : null;
        }
        String value = BundleLauncherHelper.writeBundles(model, startLevel, autoStart);
        buffer.append(value);
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        super.initializeFrom(configuration);
        this.levelColumnCache = new HashMap();
        this.autoColumnCache = new HashMap();
        this.initWorkspacePluginsState(configuration);
        this.initExternalPluginsState(configuration);
        this.updateCounter();
        this.fLaunchConfiguration = configuration;
        this.handleFilterButton();
    }

    private void initExternalPluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getTargetBundleMap(configuration);
        Iterator iter = map.keySet().iterator();
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fExternalPlugins, false);
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumExternalChecked = map.size();
        this.resetGroup(this.fExternalPlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
    }

    private void resetGroup(NamedElement group) {
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)group);
        if (widget instanceof TreeItem) {
            TreeItem[] items = ((TreeItem)widget).getItems();
            int i = 0;
            while (i < items.length) {
                Object model;
                if (!items[i].getChecked() && (model = items[i].getData()) instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)model);
                }
                ++i;
            }
        }
    }

    private void initWorkspacePluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getWorkspaceBundleMap(configuration);
        Iterator iter = map.keySet().iterator();
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, false);
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumWorkspaceChecked = map.size();
        this.resetGroup(this.fWorkspacePlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    protected void handleGroupStateChanged(Object group, boolean checked) {
        NamedElement namedElement;
        TreeItem item;
        super.handleGroupStateChanged(group, checked);
        if (group instanceof NamedElement && (item = (TreeItem)this.fPluginTreeViewer.testFindItem((Object)(namedElement = (NamedElement)group))) != null) {
            TreeItem[] children = item.getItems();
            if (children == null) {
                return;
            }
            int i = 0;
            while (i < children.length) {
                TreeItem childItem = children[i];
                Object child = childItem.getData();
                if (child instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)child);
                }
                ++i;
            }
        }
    }

    protected void handleCheckStateChanged(CheckStateChangedEvent event) {
        super.handleCheckStateChanged(event);
        this.resetText((IPluginModelBase)event.getElement());
    }

    protected void setChecked(IPluginModelBase model, boolean checked) {
        super.setChecked(model, checked);
        this.resetText(model);
    }

    protected void setCheckedElements(Object[] checked) {
        super.setCheckedElements(checked);
        this.updateGroup(this.fWorkspacePlugins);
        this.updateGroup(this.fExternalPlugins);
    }

    private void updateGroup(Object group) {
        Widget item = this.fPluginTreeViewer.testFindItem(group);
        if (item instanceof TreeItem) {
            TreeItem[] items = ((TreeItem)item).getItems();
            int i = 0;
            while (i < items.length) {
                Object model;
                TreeItem child = items[i];
                if (child.getChecked() == (child.getText(1).length() == 0) && (model = items[i].getData()) instanceof IPluginModelBase) {
                    this.resetText((IPluginModelBase)model);
                }
                ++i;
            }
        }
    }

    private void setText(IPluginModelBase model, String value) {
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)model);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            int index = value == null ? -1 : value.indexOf(58);
            String levelValue = index == -1 ? "" : value.substring(0, index);
            String autoValue = null;
            item.setText(1, levelValue);
            if (model.isFragmentModel()) {
                autoValue = "false";
                item.setText(2, autoValue);
            } else {
                autoValue = index == -1 ? "" : value.substring(index + 1);
                item.setText(2, autoValue);
            }
            this.levelColumnCache.put(model, levelValue);
            this.autoColumnCache.put(model, autoValue);
        }
    }

    private void resetText(IPluginModelBase model) {
        String levelText = null;
        String autoText = null;
        Widget widget = this.fPluginTreeViewer.testFindItem((Object)model);
        if (this.fPluginTreeViewer.getChecked((Object)model)) {
            String systemBundleId = PDECore.getDefault().getModelManager().getSystemBundleId();
            boolean isSystemBundle = systemBundleId.equals(model.getPluginBase().getId());
            levelText = isSystemBundle ? "" : "default";
            String string = autoText = isSystemBundle ? "" : "default";
            if (this.levelColumnCache.containsKey(model) && !isSystemBundle) {
                levelText = (String)this.levelColumnCache.get(model);
                String string2 = levelText = levelText.length() > 0 ? levelText : "default";
            }
            if (this.autoColumnCache.containsKey(model) && !isSystemBundle) {
                autoText = (String)this.autoColumnCache.get(model);
                String string3 = autoText = autoText.length() > 0 ? autoText : "default";
            }
            if (model.isFragmentModel()) {
                autoText = "false";
            }
        } else {
            levelText = "";
            autoText = "";
        }
        if (levelText != null) {
            this.levelColumnCache.put(model, levelText);
            if (widget instanceof TreeItem) {
                ((TreeItem)widget).setText(1, levelText);
            }
        }
        if (autoText != null) {
            this.autoColumnCache.put(model, autoText);
            if (widget instanceof TreeItem) {
                ((TreeItem)widget).setText(2, autoText);
            }
        }
    }

    protected void handleRestoreDefaults() {
        Object[] selected = this.fPluginTreeViewer.getCheckedElements();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof IPluginModelBase) {
                this.resetText((IPluginModelBase)selected[i]);
            }
            ++i;
        }
    }

    protected int getTreeViewerStyle() {
        return super.getTreeViewerStyle() | 0x10000;
    }

    protected LaunchValidationOperation createValidationOperation() {
        return new OSGiValidationOperation(this.fLaunchConfiguration);
    }

    protected void refreshTreeView(CheckboxTreeViewer treeView) {
        if (treeView.getTree().getItemCount() > 0) {
            treeView.getTree().setSelection(treeView.getTree().getItem(0));
        } else {
            treeView.setSelection((ISelection)new StructuredSelection((Object)StructuredSelection.EMPTY));
        }
        if (this.levelColumnEditor != null && this.levelColumnEditor.getEditor() != null && !this.levelColumnEditor.getEditor().isDisposed()) {
            this.levelColumnEditor.getEditor().dispose();
        }
        if (this.autoColumnEditor != null && this.autoColumnEditor.getEditor() != null && !this.autoColumnEditor.getEditor().isDisposed()) {
            this.autoColumnEditor.getEditor().dispose();
        }
    }

    class OSGiLabelProvider
    extends PDELabelProvider {
        OSGiLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            return index == 0 ? super.getColumnImage(obj, index) : null;
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 0: {
                    return super.getColumnText(obj, index);
                }
                case 1: {
                    if (OSGiBundleBlock.this.levelColumnCache != null && OSGiBundleBlock.this.levelColumnCache.containsKey(obj)) {
                        return (String)OSGiBundleBlock.this.levelColumnCache.get(obj);
                    }
                    return "";
                }
                case 2: {
                    if (OSGiBundleBlock.this.autoColumnCache != null && OSGiBundleBlock.this.autoColumnCache.containsKey(obj)) {
                        return (String)OSGiBundleBlock.this.autoColumnCache.get(obj);
                    }
                    return "";
                }
            }
            return "";
        }
    }
}

