/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.ui.launcher.LaunchValidationOperation;
import org.eclipse.swt.graphics.Image;

public class EclipsePluginValidationOperation
extends LaunchValidationOperation {
    private Map fExtensionErrors = new HashMap(2);
    private static Object[] EMPTY = new Object[0];

    public EclipsePluginValidationOperation(ILaunchConfiguration configuration) {
        super(configuration);
    }

    protected IPluginModelBase[] getModels() throws CoreException {
        return LaunchPluginValidator.getPluginList(this.fLaunchConfiguration);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        super.run(monitor);
        if (this.fExtensionErrors.size() > 0) {
            this.fExtensionErrors.clear();
        }
        this.validateExtensions();
    }

    private void validateExtensions() {
        try {
            if (this.fLaunchConfiguration.getAttribute("useProduct", false)) {
                String product = this.fLaunchConfiguration.getAttribute("product", null);
                if (product != null) {
                    this.validateExtension(product);
                    String application = this.getApplication(product);
                    if (application != null) {
                        this.validateExtension(application);
                    }
                }
            } else {
                String configType = this.fLaunchConfiguration.getType().getIdentifier();
                String attribute = configType.equals("org.eclipse.pde.ui.RuntimeWorkbench") ? "application" : "testApplication";
                String application = this.fLaunchConfiguration.getAttribute(attribute, TargetPlatform.getDefaultApplication());
                if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                    this.validateExtension(application);
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    private String getApplication(String product) {
        IPluginModelBase model;
        String bundleID = product.substring(0, product.lastIndexOf(46));
        BundleDescription bundle = this.getState().getBundle(bundleID, null);
        if (bundle != null && (model = PluginRegistry.findModel((BundleDescription)bundle)) != null) {
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IPluginElement prod;
                IPluginExtension ext = extensions[i];
                String point = ext.getPoint();
                if ("org.eclipse.core.runtime.products".equals(point) && product.equals(IdUtil.getFullId((IPluginExtension)ext)) && ext.getChildCount() == 1 && (prod = (IPluginElement)ext.getChildren()[0]).getName().equals("product")) {
                    IPluginAttribute attr = prod.getAttribute("application");
                    return attr != null ? attr.getValue() : null;
                }
                ++i;
            }
        }
        return null;
    }

    private void validateExtension(String id) {
        String bundleID = id.substring(0, id.lastIndexOf(46));
        BundleDescription bundle = this.getState().getBundle(bundleID, null);
        if (bundle == null) {
            String name = NLS.bind((String)PDEUIMessages.EclipsePluginValidationOperation_pluginMissing, (Object)bundleID);
            PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
            Image image = provider.get(PDEPluginImages.DESC_PLUGIN_OBJ);
            this.fExtensionErrors.put(new NamedElement(name, image), EMPTY);
        }
    }

    public boolean hasErrors() {
        return super.hasErrors() || this.fExtensionErrors.size() >= 1;
    }

    public Map getInput() {
        Map map = super.getInput();
        map.putAll(this.fExtensionErrors);
        return map;
    }
}

