/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.launcher.LaunchPluginValidator;

public class BundleLauncherHelper {
    public static final char VERSION_SEPARATOR = '*';

    public static Map getWorkspaceBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getWorkspaceBundleMap(configuration, null);
    }

    public static Map getWorkspaceBundleMap(ILaunchConfiguration configuration, Set set) throws CoreException {
        String selected = configuration.getAttribute("workspace_bundles", "");
        HashMap<IPluginModelBase, String> map = new HashMap<IPluginModelBase, String>();
        StringTokenizer tok = new StringTokenizer(selected, ",");
        while (tok.hasMoreTokens()) {
            ModelEntry entry;
            String version;
            int index;
            String token = tok.nextToken();
            String idVersion = token.substring(0, index = token.indexOf(64));
            int versionIndex = idVersion.indexOf(42);
            String id = versionIndex > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String string = version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            if (set != null) {
                set.add(id);
            }
            if ((entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                IPluginBase base = models[i].getPluginBase();
                if (base.getVersion().equals(version) || version == null) {
                    map.put(models[i], token.substring(index + 1));
                }
                ++i;
            }
        }
        if (configuration.getAttribute("automaticAdd", true)) {
            Set deselectedPlugins = LaunchPluginValidator.parsePlugins(configuration, "deselected_workspace_plugins");
            IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null && !deselectedPlugins.contains(models[i])) {
                    if (set != null) {
                        set.add(id);
                    }
                    if (!map.containsKey(models[i])) {
                        map.put(models[i], "default:default");
                    }
                }
                ++i;
            }
        }
        return map;
    }

    public static IPluginModelBase[] getWorkspaceBundles(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getWorkspaceBundleMap(configuration);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map getTargetBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getTargetBundleMap(configuration, new HashSet());
    }

    public static Map getTargetBundleMap(ILaunchConfiguration configuration, Set set) throws CoreException {
        String selected = configuration.getAttribute("target_bundles", "");
        HashMap<IPluginModelBase, String> map = new HashMap<IPluginModelBase, String>();
        StringTokenizer tok = new StringTokenizer(selected, ",");
        while (tok.hasMoreTokens()) {
            ModelEntry entry;
            String version;
            int index;
            String token = tok.nextToken();
            String idVersion = token.substring(0, index = token.indexOf(64));
            int versionIndex = idVersion.indexOf(42);
            String id = versionIndex > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String string = version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            if (set.contains(id) || (entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getExternalModels();
            int i = 0;
            while (i < models.length) {
                IPluginBase base = models[i].getPluginBase();
                if (base.getVersion().equals(version) || version == null) {
                    map.put(models[i], token.substring(index + 1));
                }
                ++i;
            }
        }
        return map;
    }

    public static IPluginModelBase[] getTargetBundles(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getTargetBundleMap(configuration);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map getMergedMap(ILaunchConfiguration configuration) throws CoreException {
        HashSet set = new HashSet();
        Map map = BundleLauncherHelper.getWorkspaceBundleMap(configuration, set);
        map.putAll(BundleLauncherHelper.getTargetBundleMap(configuration, set));
        return map;
    }

    public static IPluginModelBase[] getMergedBundles(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getMergedMap(configuration);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }

    public static String writeBundles(IPluginModelBase model, String startLevel, String autoStart) {
        IPluginBase base = model.getPluginBase();
        String id = base.getId();
        StringBuffer buffer = new StringBuffer(id);
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry.getActiveModels().length > 1) {
            buffer.append('*');
            buffer.append(model.getPluginBase().getVersion());
        }
        if (startLevel != null || autoStart != null) {
            buffer.append('@');
        }
        if (startLevel != null) {
            buffer.append(startLevel);
        }
        if (startLevel != null && autoStart != null) {
            buffer.append(':');
        }
        if (autoStart != null) {
            buffer.append(autoStart);
        }
        return buffer.toString();
    }
}

