/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.toc;

import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.util.XMLRootElementMatcher;

public class HelpEditorUtil {
    public static final String[] pageExtensions = new String[]{"htm", "shtml", "html", "xhtml"};
    public static final String tocExtension = "xml";
    private static HashSet pageExtensionSet = new HashSet(pageExtensions.length);

    private static void populateHashSet() {
        int i = 0;
        while (i < pageExtensions.length) {
            pageExtensionSet.add(pageExtensions[i]);
            ++i;
        }
    }

    public static boolean hasValidPageExtension(IPath path) {
        String fileExtension = path.getFileExtension();
        if (fileExtension != null) {
            fileExtension = fileExtension.toLowerCase(Locale.ENGLISH);
            if (pageExtensionSet.isEmpty()) {
                HelpEditorUtil.populateHashSet();
            }
            return pageExtensionSet.contains(fileExtension);
        }
        return false;
    }

    private static boolean hasValidTocExtension(IPath path) {
        String fileExtension = path.getFileExtension();
        return fileExtension != null && fileExtension.equals(tocExtension);
    }

    public static boolean isTOCFile(IPath path) {
        if (!HelpEditorUtil.hasValidTocExtension(path)) {
            return false;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(path);
        if (resource != null && resource instanceof IFile) {
            return XMLRootElementMatcher.fileMatchesElement((IFile)resource, "toc");
        }
        return XMLRootElementMatcher.fileMatchesElement(path.toFile(), "toc");
    }

    public static boolean isCurrentResource(IPath path, IBaseModel model) {
        if (model instanceof IModel) {
            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            IPath fullPath = workspacePath.isPrefixOf(path) ? ((IModel)model).getUnderlyingResource().getLocation() : ((IModel)model).getUnderlyingResource().getFullPath();
            return fullPath.equals((Object)path);
        }
        return false;
    }

    public static String getPageExtensionList() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < pageExtensions.length) {
            buf.append('.');
            buf.append(pageExtensions[i]);
            if (i != pageExtensions.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }
}

