/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.target;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.target.TargetProfileWindow;
import org.eclipse.swt.widgets.Shell;

public class OpenTargetProfileAction
extends Action {
    private ITargetModel fTargetModel;
    private Shell fShell;
    private String fTargetName;

    public OpenTargetProfileAction(Shell shell, ITargetModel model, String targetName) {
        this.fShell = shell;
        this.fTargetModel = model;
        this.fTargetName = targetName;
    }

    public void run() {
        if (this.fTargetModel == null) {
            MessageDialog.openError((Shell)this.fShell, (String)PDEUIMessages.OpenTargetProfileAction_title, (String)PDEUIMessages.OpenTargetProfileAction_missingProfile);
            return;
        }
        if (!this.fTargetModel.isLoaded()) {
            MessageDialog.openError((Shell)this.fShell, (String)PDEUIMessages.OpenTargetProfileAction_title, (String)PDEUIMessages.OpenTargetProfileAction_invalidProfile);
            return;
        }
        TargetProfileWindow appWindow = new TargetProfileWindow(this.fShell, this.fTargetModel, this.fTargetName);
        appWindow.create();
        appWindow.open();
    }
}

